/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.entities;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.UserConsentModel;

public class CachedUserConsent {
    private final String clientDbId;
    private final Set<String> clientScopeIds = new HashSet<String>();
    private final Long createdDate;
    private final Long lastUpdatedDate;
    private boolean notExistent;

    public CachedUserConsent(UserConsentModel consentModel) {
        this.clientDbId = consentModel.getClient().getId();
        for (ClientScopeModel clientScope : consentModel.getGrantedClientScopes()) {
            this.clientScopeIds.add(clientScope.getId());
        }
        this.createdDate = consentModel.getCreatedDate();
        this.lastUpdatedDate = consentModel.getLastUpdatedDate();
    }

    public CachedUserConsent(String clientDbId) {
        this.clientDbId = clientDbId;
        this.createdDate = null;
        this.lastUpdatedDate = null;
        this.notExistent = true;
    }

    public String getClientDbId() {
        return this.clientDbId;
    }

    public Set<String> getClientScopeIds() {
        return this.clientScopeIds;
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public Long getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public boolean isNotExistent() {
        return this.notExistent;
    }
}

