/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.client;

import java.util.Map;
import java.util.stream.Stream;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.RealmModel;

public interface ClientLookupProvider {
    public ClientModel getClientById(RealmModel var1, String var2);

    public ClientModel getClientByClientId(RealmModel var1, String var2);

    public Stream<ClientModel> searchClientsByClientIdStream(RealmModel var1, String var2, Integer var3, Integer var4);

    public Stream<ClientModel> searchClientsByAttributes(RealmModel var1, Map<String, String> var2, Integer var3, Integer var4);

    default public Stream<ClientModel> searchClientsByAuthenticationFlowBindingOverrides(RealmModel realm, Map<String, String> overrides, Integer firstResult, Integer maxResults) {
        Stream<ClientModel> clients = this.searchClientsByAttributes(realm, Map.of(), null, null).filter(client -> overrides.entrySet().stream().allMatch(override -> ((String)override.getValue()).equals(client.getAuthenticationFlowBindingOverrides().get(override.getKey()))));
        if (firstResult != null && firstResult >= 0) {
            clients = clients.skip(firstResult.intValue());
        }
        if (maxResults != null && maxResults >= 0) {
            clients = clients.limit(maxResults.intValue());
        }
        return clients;
    }

    public Map<String, ClientScopeModel> getClientScopes(RealmModel var1, ClientModel var2, boolean var3);
}

