/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.graal;

import io.quarkus.runtime.graal.GraalVM;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeResourceAccess;

public class Brotli4jFeature
implements Feature {
    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        String customPath = System.getProperty("brotli4j.library.path");
        if (customPath != null && !customPath.isEmpty()) {
            RuntimeResourceAccess.addResource((Module)Brotli4jFeature.class.getModule(), (String)customPath);
        } else {
            String nativeLibName = System.mapLibraryName("brotli");
            String platform = Brotli4jFeature.getPlatform();
            String libPath = "lib/" + platform + "/" + nativeLibName;
            RuntimeResourceAccess.addResource((Module)Brotli4jFeature.class.getModule(), (String)libPath);
        }
        RuntimeResourceAccess.addResource((Module)Brotli4jFeature.class.getModule(), (String)"META-INF/services/com.aayushatharva.brotli4j.service.BrotliNativeProvider");
        RuntimeClassInitialization.initializeAtRunTime((String[])new String[]{"com.aayushatharva.brotli4j.Brotli4jLoader"});
        GraalVM.Version v = GraalVM.Version.getCurrent();
        if (v.compareTo(GraalVM.Version.VERSION_23_1_0) <= 0) {
            RuntimeClassInitialization.initializeAtRunTime((String[])new String[]{"io.netty.handler.codec.compression.Brotli"});
        }
    }

    private static String getPlatform() {
        String osName = System.getProperty("os.name");
        String archName = System.getProperty("os.arch");
        if ("Linux".equalsIgnoreCase(osName)) {
            if ("amd64".equalsIgnoreCase(archName)) {
                return "linux-x86_64";
            }
            if ("aarch64".equalsIgnoreCase(archName)) {
                return "linux-aarch64";
            }
            if ("arm".equalsIgnoreCase(archName)) {
                return "linux-armv7";
            }
            if ("s390x".equalsIgnoreCase(archName)) {
                return "linux-s390x";
            }
            if ("ppc64le".equalsIgnoreCase(archName)) {
                return "linux-ppc64le";
            }
            if ("riscv64".equalsIgnoreCase(archName)) {
                return "linux-riscv64";
            }
        } else if (osName.startsWith("Windows")) {
            if ("amd64".equalsIgnoreCase(archName)) {
                return "windows-x86_64";
            }
            if ("aarch64".equalsIgnoreCase(archName)) {
                return "windows-aarch64";
            }
        } else if (osName.startsWith("Mac")) {
            if ("x86_64".equalsIgnoreCase(archName)) {
                return "osx-x86_64";
            }
            if ("aarch64".equalsIgnoreCase(archName)) {
                return "osx-aarch64";
            }
        }
        throw new UnsupportedOperationException("Unsupported OS and Architecture: " + osName + ", " + archName);
    }
}

