/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.BiConsumer;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.CollectionIdentifierDescriptor;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;

public class CollectionIdentifierDescriptorImpl
implements CollectionIdentifierDescriptor,
FetchOptions {
    private final NavigableRole navigableRole;
    private final CollectionPersister collectionDescriptor;
    private final String containingTableName;
    private final String columnName;
    private final BasicType<?> type;

    public CollectionIdentifierDescriptorImpl(CollectionPersister collectionDescriptor, String containingTableName, String columnName, BasicType<?> type) {
        this.navigableRole = collectionDescriptor.getNavigableRole().append(CollectionPart.Nature.ID.getName());
        this.collectionDescriptor = collectionDescriptor;
        this.containingTableName = containingTableName;
        this.columnName = columnName;
        this.type = type;
    }

    @Override
    public CollectionPart.Nature getNature() {
        return CollectionPart.Nature.ID;
    }

    @Override
    public PluralAttributeMapping getCollectionAttribute() {
        return this.collectionDescriptor.getAttributeMapping();
    }

    @Override
    public String getContainingTableExpression() {
        return this.containingTableName;
    }

    @Override
    public String getSelectionExpression() {
        return this.columnName;
    }

    @Override
    public boolean isFormula() {
        return false;
    }

    @Override
    public boolean isInsertable() {
        return true;
    }

    @Override
    public boolean isUpdateable() {
        return false;
    }

    @Override
    public boolean isPartitioned() {
        return false;
    }

    @Override
    public boolean hasPartitionedSelectionMapping() {
        return false;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public String getCustomReadExpression() {
        return null;
    }

    @Override
    public String getCustomWriteExpression() {
        return null;
    }

    @Override
    public String getColumnDefinition() {
        return null;
    }

    @Override
    public Long getLength() {
        return null;
    }

    @Override
    public Integer getPrecision() {
        return null;
    }

    @Override
    public Integer getScale() {
        return null;
    }

    @Override
    public Integer getTemporalPrecision() {
        return null;
    }

    @Override
    public MappingType getPartMappingType() {
        return this.type;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.type;
    }

    @Override
    public MappingType getMappedType() {
        return this.type;
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.getMappedType().getMappedJavaType();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return this.collectionDescriptor.getAttributeMapping().createDomainResult(navigablePath, tableGroup, resultVariable, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.collectionDescriptor.getAttributeMapping().applySqlSelections(navigablePath, tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        this.collectionDescriptor.getAttributeMapping().applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        consumer.accept(offset, this);
        return this.getJdbcTypeCount();
    }

    @Override
    public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(offset, x, y, domainValue, this);
        return this.getJdbcTypeCount();
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.collectionDescriptor.getAttributeMapping().findContainingEntityMapping();
    }

    @Override
    public String getFetchableName() {
        return null;
    }

    @Override
    public int getFetchableKey() {
        return -1;
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this;
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        FromClauseAccess fromClauseAccess = creationState.getSqlAstCreationState().getFromClauseAccess();
        TableGroup tableGroup = fromClauseAccess.getTableGroup(fetchablePath.getParent());
        SqlAstCreationState astCreationState = creationState.getSqlAstCreationState();
        SqlAstCreationContext astCreationContext = astCreationState.getCreationContext();
        SessionFactoryImplementor sessionFactory = astCreationContext.getSessionFactory();
        SqlExpressionResolver sqlExpressionResolver = astCreationState.getSqlExpressionResolver();
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(tableGroup.getPrimaryTableReference(), this), this.type.getJdbcJavaType(), fetchParent, sessionFactory.getTypeConfiguration());
        return new BasicFetch(sqlSelection.getValuesArrayPosition(), fetchParent, fetchablePath, this, FetchTiming.IMMEDIATE, creationState, !sqlSelection.isVirtual());
    }

    public DomainResult<?> createDomainResult(NavigablePath collectionPath, TableGroup tableGroup, DomainResultCreationState creationState) {
        SqlAstCreationState astCreationState = creationState.getSqlAstCreationState();
        SqlAstCreationContext astCreationContext = astCreationState.getCreationContext();
        SessionFactoryImplementor sessionFactory = astCreationContext.getSessionFactory();
        SqlExpressionResolver sqlExpressionResolver = astCreationState.getSqlExpressionResolver();
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(tableGroup.getPrimaryTableReference(), this), this.type.getJdbcJavaType(), null, sessionFactory.getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), null, this.type, collectionPath, false, !sqlSelection.isVirtual());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.collectionDescriptor.getRole() + ")";
    }

    @Override
    public FetchStyle getStyle() {
        return FetchStyle.JOIN;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.type.disassemble(value, session);
    }

    @Override
    public void addToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, SharedSessionContractImplementor session) {
        this.type.addToCacheKey(cacheKey, value, session);
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        return this.type.forEachDisassembledJdbcValue(value, offset, x, y, valuesConsumer, session);
    }
}

