/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.insert;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.EventType;
import org.hibernate.generator.values.GeneratedValueBasicResultBuilder;
import org.hibernate.generator.values.internal.GeneratedValuesHelper;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.AbstractSelectingDelegate;
import org.hibernate.jdbc.Expectation;
import org.hibernate.metamodel.mapping.EntityRowIdMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.sql.model.ast.builder.TableInsertBuilderStandard;
import org.hibernate.sql.model.ast.builder.TableMutationBuilder;
import org.hibernate.type.Type;

public class UniqueKeySelectingDelegate
extends AbstractSelectingDelegate {
    private final String[] uniqueKeyPropertyNames;
    private final Type[] uniqueKeyTypes;
    private final String selectString;

    @Deprecated(forRemoval=true, since="6.5")
    public UniqueKeySelectingDelegate(PostInsertIdentityPersister persister, Dialect dialect, String[] uniqueKeyPropertyNames) {
        this((EntityPersister)persister, uniqueKeyPropertyNames, EventType.INSERT);
    }

    public UniqueKeySelectingDelegate(EntityPersister persister, String[] uniqueKeyPropertyNames, EventType timing) {
        super(persister, timing, true, true);
        this.uniqueKeyPropertyNames = uniqueKeyPropertyNames;
        this.uniqueKeyTypes = new Type[uniqueKeyPropertyNames.length];
        for (int i = 0; i < uniqueKeyPropertyNames.length; ++i) {
            this.uniqueKeyTypes[i] = persister.getPropertyType(uniqueKeyPropertyNames[i]);
        }
        EntityRowIdMapping rowIdMapping = persister.getRowIdMapping();
        if (!persister.isIdentifierAssignedByInsert() || persister.getInsertGeneratedProperties().size() > 1 || rowIdMapping != null) {
            List<GeneratedValueBasicResultBuilder> resultBuilders = this.jdbcValuesMappingProducer.getResultBuilders();
            ArrayList<String> columnNames = new ArrayList<String>(resultBuilders.size());
            for (GeneratedValueBasicResultBuilder resultBuilder : resultBuilders) {
                columnNames.add(GeneratedValuesHelper.getActualGeneratedModelPart(resultBuilder.getModelPart()).getSelectionExpression());
            }
            this.selectString = persister.getSelectByUniqueKeyString(uniqueKeyPropertyNames, columnNames.toArray(new String[0]));
        } else {
            this.selectString = persister.getSelectByUniqueKeyString(uniqueKeyPropertyNames);
        }
    }

    @Override
    protected String getSelectSQL() {
        return this.selectString;
    }

    @Override
    public TableMutationBuilder<?> createTableMutationBuilder(Expectation expectation, SessionFactoryImplementor factory) {
        return new TableInsertBuilderStandard(this.persister, this.persister.getIdentifierTableMapping(), factory);
    }

    @Override
    protected void bindParameters(Object entity, PreparedStatement ps, SharedSessionContractImplementor session) throws SQLException {
        int index = 1;
        for (int i = 0; i < this.uniqueKeyPropertyNames.length; ++i) {
            this.uniqueKeyTypes[i].nullSafeSet(ps, this.persister.getPropertyValue(entity, this.uniqueKeyPropertyNames[i]), index, session);
            index += this.uniqueKeyTypes[i].getColumnSpan(session.getFactory());
        }
    }
}

