/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.PersistentObjectException;
import org.hibernate.TypeMismatchException;
import org.hibernate.action.internal.DelayedPostInsertIdentifier;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.loader.ast.internal.CacheEntityLoaderHelper;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.CompositeIdentifierMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.NonAggregatedIdentifierMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.stat.spi.StatisticsImplementor;

public class DefaultLoadEventListener
implements LoadEventListener {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultLoadEventListener.class);

    @Override
    public void onLoad(LoadEvent event, LoadEventListener.LoadType loadType) throws HibernateException {
        EntityPersister persister = this.getPersister(event);
        if (persister == null) {
            throw new HibernateException("Unable to locate persister: " + event.getEntityClassName());
        }
        this.checkId(event, loadType, persister);
        this.doOnLoad(persister, event, loadType);
    }

    private void checkId(LoadEvent event, LoadEventListener.LoadType loadType, EntityPersister persister) {
        Class<?> idClass;
        Object id = event.getEntityId();
        if (!persister.getIdentifierMapping().getJavaType().isInstance(id) && !(id instanceof DelayedPostInsertIdentifier) && this.handleIdType(persister, event, loadType, idClass = persister.getIdentifierType().getReturnedClass())) {
            throw new TypeMismatchException("Supplied id had wrong type: entity '" + persister.getEntityName() + "' has id type '" + idClass + "' but supplied id was of type '" + event.getEntityId().getClass() + "'");
        }
    }

    protected EntityPersister getPersister(LoadEvent event) {
        Object instanceToLoad = event.getInstanceToLoad();
        if (instanceToLoad != null) {
            event.setEntityClassName(instanceToLoad.getClass().getName());
            return event.getSession().getEntityPersister(null, instanceToLoad);
        }
        return event.getFactory().getMappingMetamodel().getEntityDescriptor(event.getEntityClassName());
    }

    private void doOnLoad(EntityPersister persister, LoadEvent event, LoadEventListener.LoadType loadType) {
        try {
            EntityKey keyToLoad = event.getSession().generateEntityKey(event.getEntityId(), persister);
            if (loadType.isNakedEntityReturned()) {
                event.setResult(this.load(event, persister, keyToLoad, loadType));
            } else {
                Object result = event.getLockMode() == LockMode.NONE ? this.proxyOrLoad(event, persister, keyToLoad, loadType) : this.lockAndLoad(event, persister, keyToLoad, loadType);
                event.setResult(result);
            }
        }
        catch (HibernateException e) {
            LOG.unableToLoadCommand(e);
            throw e;
        }
    }

    private boolean handleIdType(EntityPersister persister, LoadEvent event, LoadEventListener.LoadType loadType, Class<?> idClass) {
        EntityIdentifierMapping idMapping = persister.getIdentifierMapping();
        if (idMapping instanceof CompositeIdentifierMapping) {
            CompositeIdentifierMapping compositeIdMapping = (CompositeIdentifierMapping)idMapping;
            EmbeddableMappingType partMappingType = compositeIdMapping.getPartMappingType();
            if (partMappingType.getNumberOfAttributeMappings() == 1) {
                AttributeMapping singleIdAttribute = partMappingType.getAttributeMapping(0);
                if (singleIdAttribute.getMappedType() instanceof EntityMappingType) {
                    MappingType parentIdType;
                    EntityMappingType parentIdTargetMapping = (EntityMappingType)singleIdAttribute.getMappedType();
                    EntityIdentifierMapping parentIdTargetIdMapping = parentIdTargetMapping.getIdentifierMapping();
                    MappingType mappingType = parentIdType = parentIdTargetIdMapping instanceof CompositeIdentifierMapping ? ((CompositeIdentifierMapping)parentIdTargetIdMapping).getMappedIdEmbeddableTypeDescriptor() : parentIdTargetIdMapping.getMappedType();
                    if (parentIdType.getMappedJavaType().getJavaTypeClass().isInstance(event.getEntityId())) {
                        this.loadByDerivedIdentitySimplePkValue(event, loadType, persister, compositeIdMapping, (EntityPersister)parentIdTargetMapping);
                        return false;
                    }
                    return !idClass.isInstance(event.getEntityId());
                }
                return !idClass.isInstance(event.getEntityId());
            }
            if (idMapping instanceof NonAggregatedIdentifierMapping) {
                return !idClass.isInstance(event.getEntityId());
            }
            return true;
        }
        return true;
    }

    private void loadByDerivedIdentitySimplePkValue(LoadEvent event, LoadEventListener.LoadType options, EntityPersister dependentPersister, CompositeIdentifierMapping dependentIdType, EntityPersister parentPersister) {
        EventSource session = event.getSession();
        EntityKey parentEntityKey = session.generateEntityKey(event.getEntityId(), parentPersister);
        Object parent = this.doLoad(event, parentPersister, parentEntityKey, options);
        Object dependent = dependentIdType.instantiate();
        dependentIdType.getPartMappingType().setValues(dependent, new Object[]{parent});
        EntityKey dependentEntityKey = session.generateEntityKey(dependent, dependentPersister);
        event.setEntityId(dependent);
        event.setResult(this.doLoad(event, dependentPersister, dependentEntityKey, options));
    }

    private Object load(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        boolean isOptionalInstance;
        if (event.getInstanceToLoad() != null) {
            EventSource session = event.getSession();
            if (session.getPersistenceContextInternal().getEntry(event.getInstanceToLoad()) != null) {
                throw new PersistentObjectException("attempted to load into an instance that was already associated with the session: " + MessageHelper.infoString(persister, event.getEntityId(), event.getFactory()));
            }
            persister.setIdentifier(event.getInstanceToLoad(), event.getEntityId(), session);
        }
        Object entity = this.doLoad(event, persister, keyToLoad, options);
        boolean bl = isOptionalInstance = event.getInstanceToLoad() != null;
        if (entity == null && (!options.isAllowNulls() || isOptionalInstance)) {
            event.getFactory().getEntityNotFoundDelegate().handleEntityNotFound(event.getEntityClassName(), event.getEntityId());
        } else if (isOptionalInstance && entity != event.getInstanceToLoad()) {
            throw new NonUniqueObjectException(event.getEntityId(), event.getEntityClassName());
        }
        return entity;
    }

    private Object proxyOrLoad(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Loading entity: {0}", MessageHelper.infoString(persister, event.getEntityId(), persister.getFactory()));
        }
        if (DefaultLoadEventListener.hasBytecodeProxy(persister, options)) {
            return this.loadWithBytecodeProxy(event, persister, keyToLoad, options);
        }
        if (persister.hasProxy()) {
            return this.loadWithRegularProxy(event, persister, keyToLoad, options);
        }
        return this.load(event, persister, keyToLoad, options);
    }

    private Object loadWithBytecodeProxy(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        Object managed;
        EventSource session = event.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        EntityHolder holder = persistenceContext.getEntityHolder(keyToLoad);
        Object object = managed = holder == null ? null : holder.getEntity();
        if (managed != null) {
            return options.isCheckDeleted() && DefaultLoadEventListener.wasDeleted(persistenceContext, managed) ? null : managed;
        }
        if (persister.getRepresentationStrategy().getProxyFactory() != null) {
            return DefaultLoadEventListener.loadWithProxyFactory(event, persister, keyToLoad, holder);
        }
        if (persister.hasSubclasses()) {
            return this.load(event, persister, keyToLoad, options);
        }
        return DefaultLoadEventListener.createBatchLoadableEnhancedProxy(persister, keyToLoad, session);
    }

    private Object loadWithRegularProxy(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        Object proxy;
        PersistenceContext persistenceContext = event.getSession().getPersistenceContextInternal();
        EntityHolder holder = persistenceContext.getEntityHolder(keyToLoad);
        Object object = proxy = holder == null ? null : holder.getProxy();
        if (proxy != null) {
            return this.narrowedProxy(event, persister, keyToLoad, options, proxy);
        }
        if (options.isAllowProxyCreation()) {
            return DefaultLoadEventListener.createProxyIfNecessary(event, persister, keyToLoad, options, holder);
        }
        return this.load(event, persister, keyToLoad, options);
    }

    private static boolean hasBytecodeProxy(EntityPersister persister, LoadEventListener.LoadType options) {
        return options.isAllowProxyCreation() && persister.getEntityPersister().getBytecodeEnhancementMetadata().isEnhancedForLazyLoading();
    }

    private static Object loadWithProxyFactory(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, EntityHolder holder) {
        Object proxy;
        EventSource session = event.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        if (holder != null && (proxy = holder.getProxy()) != null) {
            LOG.trace("Entity proxy found in session cache");
            if (LOG.isDebugEnabled() && HibernateProxy.extractLazyInitializer(proxy).isUnwrap()) {
                LOG.debug("Ignoring NO_PROXY to honor laziness");
            }
            return persistenceContext.narrowProxy(proxy, persister, keyToLoad, null);
        }
        if (persister.hasSubclasses()) {
            return DefaultLoadEventListener.proxyOrCached(event, persister, keyToLoad);
        }
        return DefaultLoadEventListener.createBatchLoadableEnhancedProxy(persister, keyToLoad, session);
    }

    private static PersistentAttributeInterceptable createBatchLoadableEnhancedProxy(EntityPersister persister, EntityKey keyToLoad, EventSource session) {
        if (keyToLoad.isBatchLoadable(session.getLoadQueryInfluencers())) {
            session.getPersistenceContextInternal().getBatchFetchQueue().addBatchLoadableEntityKey(keyToLoad);
        }
        return persister.getBytecodeEnhancementMetadata().createEnhancedProxy(keyToLoad, true, session);
    }

    private static Object proxyOrCached(LoadEvent event, EntityPersister persister, EntityKey keyToLoad) {
        Object cachedEntity = CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(event.getSession(), null, LockMode.NONE, persister, keyToLoad);
        if (cachedEntity != null) {
            return cachedEntity;
        }
        return DefaultLoadEventListener.createProxy(event, persister, keyToLoad);
    }

    private Object narrowedProxy(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options, Object proxy) {
        LazyInitializer li;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Entity proxy found in session cache");
        }
        if ((li = HibernateProxy.extractLazyInitializer(proxy)).isUnwrap()) {
            return li.getImplementation();
        }
        PersistenceContext persistenceContext = event.getSession().getPersistenceContextInternal();
        if (options.isAllowProxyCreation()) {
            return persistenceContext.narrowProxy(proxy, persister, keyToLoad, null);
        }
        Object impl = this.proxyImplementation(event, persister, keyToLoad, options);
        return impl == null ? null : persistenceContext.narrowProxy(proxy, persister, keyToLoad, impl);
    }

    private Object proxyImplementation(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        Object entity = this.load(event, persister, keyToLoad, options);
        if (entity != null) {
            return entity;
        }
        if (options != LoadEventListener.INTERNAL_LOAD_NULLABLE) {
            event.getFactory().getEntityNotFoundDelegate().handleEntityNotFound(persister.getEntityName(), keyToLoad.getIdentifier());
        }
        return null;
    }

    private static Object createProxyIfNecessary(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options, EntityHolder holder) {
        Object existing;
        Object object = existing = holder == null ? null : holder.getEntity();
        if (existing != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Entity found in session cache");
            }
            return options.isCheckDeleted() && DefaultLoadEventListener.wasDeleted(event.getSession().getPersistenceContextInternal(), existing) ? null : existing;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating new proxy for entity");
        }
        return DefaultLoadEventListener.createProxy(event, persister, keyToLoad);
    }

    private static boolean wasDeleted(PersistenceContext persistenceContext, Object existing) {
        return persistenceContext.getEntry(existing).getStatus().isDeletedOrGone();
    }

    private static Object createProxy(LoadEvent event, EntityPersister persister, EntityKey keyToLoad) {
        EventSource session = event.getSession();
        Object proxy = persister.createProxy(event.getEntityId(), session);
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        persistenceContext.getBatchFetchQueue().addBatchLoadableEntityKey(keyToLoad);
        persistenceContext.addProxy(keyToLoad, proxy);
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object lockAndLoad(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        Object entity;
        SoftLock lock;
        Object ck;
        EventSource source = event.getSession();
        EntityDataAccess cache = persister.getCacheAccessStrategy();
        boolean canWriteToCache = persister.canWriteToCache();
        if (canWriteToCache) {
            ck = cache.generateCacheKey(event.getEntityId(), persister, event.getFactory(), source.getTenantIdentifier());
            lock = cache.lockItem(source, ck, null);
        } else {
            lock = null;
            ck = null;
        }
        try {
            entity = this.load(event, persister, keyToLoad, options);
            if (!canWriteToCache) return source.getPersistenceContextInternal().proxyFor(persister, keyToLoad, entity);
        }
        catch (Throwable throwable) {
            if (!canWriteToCache) throw throwable;
            cache.unlockItem(source, ck, lock);
            throw throwable;
        }
        cache.unlockItem(source, ck, lock);
        return source.getPersistenceContextInternal().proxyFor(persister, keyToLoad, entity);
    }

    private Object doLoad(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) {
        EventSource session = event.getSession();
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Attempting to resolve: {0}", MessageHelper.infoString(persister, event.getEntityId(), event.getFactory()));
        }
        if (session.getPersistenceContextInternal().containsDeletedUnloadedEntityKey(keyToLoad)) {
            return null;
        }
        CacheEntityLoaderHelper.PersistenceContextEntry persistenceContextEntry = CacheEntityLoaderHelper.INSTANCE.loadFromSessionCache(event, keyToLoad, options);
        Object entity = persistenceContextEntry.getEntity();
        if (entity != null) {
            if (persistenceContextEntry.isManaged()) {
                DefaultLoadEventListener.initializeIfNecessary(entity);
                return entity;
            }
            return null;
        }
        return this.load(event, persister, keyToLoad);
    }

    private static void initializeIfNecessary(Object entity) {
        PersistentAttributeInterceptable interceptable;
        PersistentAttributeInterceptor interceptor;
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(entity) && (interceptor = (interceptable = ManagedTypeHelper.asPersistentAttributeInterceptable(entity)).$$_hibernate_getInterceptor()) instanceof EnhancementAsProxyLazinessInterceptor) {
            ((EnhancementAsProxyLazinessInterceptor)interceptor).forceInitialize(entity, null);
        }
    }

    private Object load(LoadEvent event, EntityPersister persister, EntityKey keyToLoad) {
        Object entity = this.loadFromCacheOrDatasource(event, persister, keyToLoad);
        if (entity != null && persister.hasNaturalIdentifier()) {
            event.getSession().getPersistenceContextInternal().getNaturalIdResolutions().cacheResolutionFromLoad(event.getEntityId(), persister.getNaturalIdMapping().extractNaturalIdFromEntity(entity), persister);
        }
        return entity;
    }

    private Object loadFromCacheOrDatasource(LoadEvent event, EntityPersister persister, EntityKey keyToLoad) {
        Object entity = CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(event, persister, keyToLoad);
        if (entity != null) {
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Resolved object in second-level cache: {0}", MessageHelper.infoString(persister, event.getEntityId(), event.getFactory()));
            }
            return entity;
        }
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Object not resolved in any cache: {0}", MessageHelper.infoString(persister, event.getEntityId(), event.getFactory()));
        }
        return this.loadFromDatasource(event, persister);
    }

    protected Object loadFromDatasource(LoadEvent event, EntityPersister persister) {
        Object entity = persister.load(event.getEntityId(), event.getInstanceToLoad(), event.getLockOptions(), (SharedSessionContractImplementor)event.getSession(), event.getReadOnly());
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(entity);
        if (lazyInitializer != null) {
            entity = lazyInitializer.getImplementation();
        }
        StatisticsImplementor statistics = event.getFactory().getStatistics();
        if (event.isAssociationFetch() && statistics.isStatisticsEnabled()) {
            statistics.fetchEntity(event.getEntityClassName());
        }
        return entity;
    }
}

