/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.binder.internal;

import java.util.HashSet;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.Comments;
import org.hibernate.binder.AttributeBinder;
import org.hibernate.binder.TypeBinder;
import org.hibernate.binder.internal.CommentBinder;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;

public class CommentsBinder
implements TypeBinder<Comments>,
AttributeBinder<Comments> {
    @Override
    public void bind(Comments comments, MetadataBuildingContext context, PersistentClass entity, Property property) {
        CommentBinder commentBinder = new CommentBinder();
        HashSet<String> ons = new HashSet<String>(comments.value().length);
        for (Comment comment : comments.value()) {
            if (!ons.add(comment.on())) {
                throw new AnnotationException("Multiple '@Comment' annotations of '" + property.getName() + "' had the same 'on'");
            }
            commentBinder.bind(comment, context, entity, property);
        }
    }

    @Override
    public void bind(Comments comments, MetadataBuildingContext context, PersistentClass entity) {
        CommentBinder commentBinder = new CommentBinder();
        HashSet<String> ons = new HashSet<String>(comments.value().length);
        for (Comment comment : comments.value()) {
            if (!ons.add(comment.on())) {
                throw new AnnotationException("Multiple '@Comment' annotations of entity '" + entity.getEntityName() + "' had the same 'on'");
            }
            commentBinder.bind(comment, context, entity);
        }
    }

    @Override
    public void bind(Comments comments, MetadataBuildingContext context, Component embeddable) {
        throw new AnnotationException("Embeddable class '" + embeddable.getComponentClassName() + "' was annotated '@Comment' (annotate its attributes instead)");
    }
}

