/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.common;

import com.google.protobuf.MessageLite;
import io.grpc.MethodDescriptor;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.GzipOptions;
import io.netty.handler.codec.compression.StandardCompressionOptions;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibEncoder;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.buffer.impl.VertxByteBufAllocator;
import io.vertx.grpc.common.GrpcMessage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Queue;

@VertxGen
public interface GrpcMessageEncoder<T> {
    public static final GrpcMessageEncoder<Buffer> IDENTITY = new GrpcMessageEncoder<Buffer>(){

        @Override
        public GrpcMessage encode(Buffer payload) {
            return GrpcMessage.message("identity", payload);
        }
    };
    public static final GrpcMessageEncoder<Buffer> GZIP = new GrpcMessageEncoder<Buffer>(){

        @Override
        public GrpcMessage encode(Buffer payload) {
            ByteBuf a;
            CompositeByteBuf composite = Unpooled.compositeBuffer();
            GzipOptions options = StandardCompressionOptions.gzip();
            ZlibEncoder encoder = ZlibCodecFactory.newZlibEncoder((ZlibWrapper)ZlibWrapper.GZIP, (int)options.compressionLevel(), (int)options.windowBits(), (int)options.memLevel());
            EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{encoder});
            channel.config().setAllocator(VertxByteBufAllocator.UNPOOLED_ALLOCATOR);
            channel.writeOutbound(new Object[]{payload.getByteBuf()});
            channel.finish();
            Queue messages = channel.outboundMessages();
            while ((a = (ByteBuf)messages.poll()) != null) {
                composite.addComponent(true, a);
            }
            channel.close();
            return GrpcMessage.message("gzip", Buffer.buffer((ByteBuf)composite));
        }
    };

    @GenIgnore
    public static <T extends MessageLite> GrpcMessageEncoder<T> encoder() {
        return msg -> {
            byte[] bytes = msg.toByteArray();
            return GrpcMessage.message("identity", Buffer.buffer((byte[])bytes));
        };
    }

    @GenIgnore(value={"permitted-type"})
    public static <T> GrpcMessageEncoder<T> marshaller(final MethodDescriptor.Marshaller<T> desc) {
        return new GrpcMessageEncoder<T>(){

            @Override
            public GrpcMessage encode(T msg) {
                Buffer encoded = Buffer.buffer();
                InputStream stream = desc.stream(msg);
                byte[] tmp = new byte[256];
                try {
                    int i;
                    while ((i = stream.read(tmp)) != -1) {
                        encoded.appendBytes(tmp, 0, i);
                    }
                }
                catch (IOException e) {
                    throw new VertxException((Throwable)e);
                }
                return GrpcMessage.message("identity", encoded);
            }
        };
    }

    public GrpcMessage encode(T var1);
}

