/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.console;

import java.nio.charset.Charset;
import java.util.function.Consumer;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.Connection;
import org.aesh.terminal.Device;
import org.aesh.terminal.tty.Capability;
import org.aesh.terminal.tty.Point;
import org.aesh.terminal.tty.Signal;
import org.aesh.terminal.tty.Size;

public class DelegateConnection
implements Connection {
    private final Connection delegate;
    private Consumer<Size> sizeHandler;
    private Consumer<Signal> signalHandler;
    private Consumer<Void> closeHandler;
    private Consumer<int[]> stdinHandler;
    private Consumer<int[]> stdoutHandler;
    volatile boolean closed;

    public DelegateConnection(Connection delegate) {
        this.delegate = delegate;
    }

    public Device device() {
        return this.delegate.device();
    }

    public Size size() {
        return this.delegate.size();
    }

    public Consumer<Size> getSizeHandler() {
        return this.sizeHandler;
    }

    public void setSizeHandler(Consumer<Size> consumer) {
        this.sizeHandler = consumer;
    }

    public Consumer<Signal> getSignalHandler() {
        return this.signalHandler;
    }

    public void setSignalHandler(Consumer<Signal> consumer) {
        this.signalHandler = consumer;
    }

    public Consumer<int[]> getStdinHandler() {
        return this.stdinHandler;
    }

    public void setStdinHandler(Consumer<int[]> consumer) {
        this.stdinHandler = consumer;
    }

    public Consumer<int[]> stdoutHandler() {
        if (this.stdoutHandler == null) {
            return this.delegate.stdoutHandler();
        }
        return this.stdoutHandler;
    }

    public void setCloseHandler(Consumer<Void> consumer) {
        this.closeHandler = consumer;
    }

    public Consumer<Void> getCloseHandler() {
        return this.closeHandler;
    }

    public void close() {
        this.closed = true;
        if (this.stdinHandler != null) {
            this.stdinHandler.accept(new int[]{-1});
        }
    }

    public void openBlocking() {
    }

    public void openNonBlocking() {
    }

    public boolean put(Capability capability, Object ... objects) {
        if (this.closed) {
            return false;
        }
        return this.delegate.put(capability, objects);
    }

    public Attributes getAttributes() {
        return this.delegate.getAttributes();
    }

    public void setAttributes(Attributes attributes) {
        if (!this.closed) {
            this.delegate.setAttributes(attributes);
        }
    }

    public Charset inputEncoding() {
        return this.delegate.inputEncoding();
    }

    public Charset outputEncoding() {
        return this.delegate.outputEncoding();
    }

    public boolean supportsAnsi() {
        return this.delegate.supportsAnsi();
    }

    public void close(int exit) {
        this.close();
    }

    public Connection write(String s) {
        if (!this.closed) {
            this.delegate.write(s);
        } else {
            System.out.println(s);
        }
        return this;
    }

    public Attributes enterRawMode() {
        if (!this.closed) {
            return this.delegate.enterRawMode();
        }
        return this.delegate.getAttributes();
    }

    public Point getCursorPosition() {
        return this.delegate.getCursorPosition();
    }
}

