/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationOverlayImpl;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationTransformation;
import org.jboss.jandex.Declaration;
import org.jboss.jandex.EquivalenceKey;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MutableAnnotationOverlay;

final class MutableAnnotationOverlayImpl
extends AnnotationOverlayImpl
implements MutableAnnotationOverlay {
    private volatile boolean frozen;

    MutableAnnotationOverlayImpl(IndexView index, boolean compatibleMode, boolean runtimeAnnotationsOnly, boolean inheritedAnnotations) {
        super(index, compatibleMode, runtimeAnnotationsOnly, inheritedAnnotations, Collections.emptyList());
    }

    @Override
    Collection<AnnotationInstance> getAnnotationsFor(final Declaration declaration) {
        EquivalenceKey.DeclarationEquivalenceKey key = EquivalenceKey.of(declaration);
        return this.overlay.computeIfAbsent(key, new Function<EquivalenceKey, Collection<AnnotationInstance>>(){

            @Override
            public Collection<AnnotationInstance> apply(EquivalenceKey ignored) {
                return new HashSet<AnnotationInstance>(MutableAnnotationOverlayImpl.this.getOriginalAnnotations(declaration));
            }
        });
    }

    @Override
    public void addAnnotation(Declaration declaration, AnnotationInstance annotation) {
        if (this.frozen) {
            throw new IllegalStateException("Mutable annotation overlay is already frozen");
        }
        if (annotation.target() == null) {
            annotation = AnnotationInstance.create(annotation, declaration);
        }
        this.getAnnotationsFor(declaration).add(annotation);
        this.transformations.add(this.addTransformation(declaration, annotation));
    }

    private AnnotationTransformation addTransformation(Declaration declaration, final AnnotationInstance annotation) {
        EquivalenceKey.DeclarationEquivalenceKey key;
        AnnotationTarget.Kind declarationKind;
        if (this.compatibleMode && declaration.kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
            declarationKind = AnnotationTarget.Kind.METHOD;
            key = EquivalenceKey.of(declaration.asMethodParameter().method());
        } else {
            declarationKind = declaration.kind();
            key = EquivalenceKey.of(declaration);
        }
        return new AnnotationTransformation(){

            @Override
            public boolean supports(AnnotationTarget.Kind kind) {
                return kind == declarationKind;
            }

            @Override
            public void apply(AnnotationTransformation.TransformationContext context) {
                if (key.equals(EquivalenceKey.of(context.declaration()))) {
                    context.add(annotation);
                }
            }

            @Override
            public boolean requiresCompatibleMode() {
                return MutableAnnotationOverlayImpl.this.compatibleMode;
            }
        };
    }

    @Override
    public void removeAnnotations(Declaration declaration, Predicate<AnnotationInstance> predicate) {
        if (this.frozen) {
            throw new IllegalStateException("Mutable annotation overlay is already frozen");
        }
        this.getAnnotationsFor(declaration).removeIf(predicate);
        this.transformations.add(this.removeTransformation(declaration, predicate));
    }

    private AnnotationTransformation removeTransformation(Declaration declaration, final Predicate<AnnotationInstance> predicate) {
        Predicate<AnnotationInstance> finalPredicate;
        EquivalenceKey.DeclarationEquivalenceKey key;
        AnnotationTarget.Kind declarationKind;
        if (this.compatibleMode && declaration.kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
            declarationKind = AnnotationTarget.Kind.METHOD;
            key = EquivalenceKey.of(declaration.asMethodParameter().method());
            final short position = declaration.asMethodParameter().position();
            finalPredicate = new Predicate<AnnotationInstance>(){

                @Override
                public boolean test(AnnotationInstance annotation) {
                    return annotation.target() != null && annotation.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER && annotation.target().asMethodParameter().position() == position && predicate.test(annotation);
                }
            };
        } else {
            declarationKind = declaration.kind();
            key = EquivalenceKey.of(declaration);
            finalPredicate = predicate;
        }
        return new AnnotationTransformation(){

            @Override
            public boolean supports(AnnotationTarget.Kind kind) {
                return kind == declarationKind;
            }

            @Override
            public void apply(AnnotationTransformation.TransformationContext context) {
                if (key.equals(EquivalenceKey.of(context.declaration()))) {
                    context.remove(finalPredicate);
                }
            }

            @Override
            public boolean requiresCompatibleMode() {
                return MutableAnnotationOverlayImpl.this.compatibleMode;
            }
        };
    }

    @Override
    public List<AnnotationTransformation> freeze() {
        this.frozen = true;
        return Collections.unmodifiableList(this.transformations);
    }
}

