/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.metadata;

import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.saml.v2.metadata.EndpointType;
import org.keycloak.dom.saml.v2.metadata.PDPDescriptorType;
import org.keycloak.dom.saml.v2.metadata.RoleDescriptorType;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLAssertinIDRequestServiceParser;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLAuthzServiceParser;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLMetadataQNames;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLRoleDecriptorTypeParser;

public class SAMLPDPDescriptorParser
extends SAMLRoleDecriptorTypeParser<PDPDescriptorType> {
    private static final SAMLPDPDescriptorParser INSTANCE = new SAMLPDPDescriptorParser();

    public SAMLPDPDescriptorParser() {
        super(SAMLMetadataQNames.PDP_DESCRIPTOR);
    }

    public static SAMLPDPDescriptorParser getInstance() {
        return INSTANCE;
    }

    @Override
    protected PDPDescriptorType instantiateElement(XMLEventReader xmlEventReader, StartElement element) throws ParsingException {
        List<String> protocolEnum = StaxParserUtil.getRequiredStringListAttributeValue(element, SAMLMetadataQNames.ATTR_PROTOCOL_SUPPORT_ENUMERATION);
        PDPDescriptorType descriptor = new PDPDescriptorType(protocolEnum);
        this.parseOptionalArguments(element, (RoleDescriptorType)descriptor);
        return descriptor;
    }

    @Override
    protected void processSubElement(XMLEventReader xmlEventReader, PDPDescriptorType target, SAMLMetadataQNames element, StartElement elementDetail) throws ParsingException {
        switch (element) {
            case AUTHZ_SERVICE: {
                target.addAuthZService((EndpointType)SAMLAuthzServiceParser.getInstance().parse(xmlEventReader));
                break;
            }
            case ASSERTION_ID_REQUEST_SERVICE: {
                target.addAssertionIDRequestService((EndpointType)SAMLAssertinIDRequestServiceParser.getInstance().parse(xmlEventReader));
                break;
            }
            case NAMEID_FORMAT: {
                StaxParserUtil.advance(xmlEventReader);
                target.addNameIDFormat(StaxParserUtil.getElementText(xmlEventReader));
                break;
            }
            default: {
                super.processSubElement(xmlEventReader, target, element, elementDetail);
            }
        }
    }
}

