/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.CompletedStage;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.Namespaces;
import io.quarkus.qute.Resolver;
import io.quarkus.qute.WithPriority;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public interface NamespaceResolver
extends Resolver,
WithPriority {
    public static Builder builder(String namespace) {
        return new Builder(namespace);
    }

    public String getNamespace();

    public static final class Builder {
        private final String namespace;
        private Function<EvalContext, CompletionStage<Object>> resolve;
        private int priority = 1;

        Builder(String namespace) {
            this.namespace = Namespaces.requireValid(namespace);
        }

        public Builder resolve(Function<EvalContext, Object> func) {
            this.resolve = ctx -> CompletedStage.of(func.apply((EvalContext)ctx));
            return this;
        }

        public Builder resolveAsync(Function<EvalContext, CompletionStage<Object>> func) {
            this.resolve = func;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public NamespaceResolver build() {
            Objects.requireNonNull(this.resolve);
            return new NamespaceResolverImpl(this.namespace, this.priority, this.resolve);
        }
    }

    public static final class NamespaceResolverImpl
    implements NamespaceResolver {
        private final String namespace;
        private final int priority;
        private final Function<EvalContext, CompletionStage<Object>> resolve;

        public NamespaceResolverImpl(String namespace, int priority, Function<EvalContext, CompletionStage<Object>> resolve) {
            this.namespace = namespace;
            this.priority = priority;
            this.resolve = resolve;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public CompletionStage<Object> resolve(EvalContext context) {
            return this.resolve.apply(context);
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }
    }
}

