/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.rpc;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.incubator.semconv.rpc.RpcAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import javax.annotation.Nullable;

abstract class RpcCommonAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    static final AttributeKey<String> RPC_METHOD = AttributeKey.stringKey((String)"rpc.method");
    static final AttributeKey<String> RPC_SERVICE = AttributeKey.stringKey((String)"rpc.service");
    static final AttributeKey<String> RPC_SYSTEM = AttributeKey.stringKey((String)"rpc.system");
    private final RpcAttributesGetter<REQUEST> getter;

    RpcCommonAttributesExtractor(RpcAttributesGetter<REQUEST> getter) {
        this.getter = getter;
    }

    public final void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, RPC_SYSTEM, (Object)this.getter.getSystem(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, RPC_SERVICE, (Object)this.getter.getService(request));
        AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, RPC_METHOD, (Object)this.getter.getMethod(request));
    }

    public final void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
    }
}

