/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.internal.models.security;

import io.smallrye.openapi.model.BaseModel;
import io.smallrye.openapi.model.DataType;
import io.smallrye.openapi.model.OpenApiVersion;
import io.smallrye.openapi.model.PropertyMetadata;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;

public abstract class AbstractSecurityRequirement
extends BaseModel<SecurityRequirement>
implements SecurityRequirement {
    public static final PropertyMetadata PROPERTIES = new Properties();

    public PropertyMetadata getPropertyMetadata() {
        return PROPERTIES;
    }

    public Map<String, List<String>> getSchemes() {
        Class<List> TYPE = List.class;
        return this.getProperties(TYPE);
    }

    public void setSchemes(Map<String, List<String>> newValue) {
        this.getSchemes().keySet().forEach(this::removeScheme);
        if (newValue != null) {
            newValue.forEach((string, list) -> this.addScheme((String)string, (List)list));
        }
    }

    public AbstractSecurityRequirement addScheme(String newKey, List<String> newValue) {
        Objects.requireNonNull(newKey, "Key must not be null");
        Objects.requireNonNull(newValue, "Value must not be null");
        this.setProperty(newKey, newValue);
        return this;
    }

    public void removeScheme(String key) {
        this.setProperty(key, null);
    }

    public static class Properties
    implements PropertyMetadata {
        private final Map<String, DataType> types = new HashMap<String, DataType>(1);
        private final Map<String, OpenApiVersion> minVersions = new HashMap<String, OpenApiVersion>(1);

        public Properties() {
            this.types.put("io.smallrye.openapi.internal.model.unwrapped", DataType.listOf((DataType)DataType.type(String.class)));
            this.minVersions.put("schemes", OpenApiVersion.V3_0);
        }

        public DataType getPropertyType(String name) {
            if (this.types.containsKey(name)) {
                return this.types.get(name);
            }
            return this.types.get("io.smallrye.openapi.internal.model.unwrapped");
        }

        public OpenApiVersion getMinVersion(String name) {
            return this.minVersions.getOrDefault(name, OpenApiVersion.V3_0);
        }
    }
}

