/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.type;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import io.vertx.codegen.type.TypeUse;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

class TreeTypeInternal
implements TypeUse.TypeInternal {
    public static final TypeUse.TypeInternalProvider PROVIDER = new TypeUse.TypeInternalProvider(){

        @Override
        public TypeUse.TypeInternal forParam(ProcessingEnvironment env, ExecutableElement methodElt, int paramIndex) {
            Trees trees = Trees.instance(env);
            if (trees == null) {
                return null;
            }
            MethodTree tree = trees.getTree(methodElt);
            if (tree == null) {
                return null;
            }
            Tree type = tree.getParameters().get(paramIndex).getType();
            return new TreeTypeInternal(type, TreeTypeInternal.isNullable(type));
        }

        @Override
        public TypeUse.TypeInternal forReturn(ProcessingEnvironment env, ExecutableElement methodElt) {
            Trees trees = Trees.instance(env);
            if (trees == null) {
                return null;
            }
            JCTree.JCMethodDecl tree = (JCTree.JCMethodDecl)trees.getTree(methodElt);
            if (tree == null) {
                return null;
            }
            JCTree type = tree.getReturnType();
            boolean nullable = TreeTypeInternal.isNullable(type);
            if (!nullable) {
                JCTree.JCModifiers mods = tree.mods;
                for (JCTree.JCAnnotation jca : mods.annotations) {
                    if (!jca.type.toString().equals(TypeUse.NULLABLE)) continue;
                    nullable = true;
                    break;
                }
            }
            return new TreeTypeInternal(type, nullable);
        }
    };
    private final Tree type;
    private final boolean nullable;

    private TreeTypeInternal(Tree type, boolean nullable) {
        this.type = type;
        this.nullable = nullable;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public String rawName() {
        if (this.type instanceof ParameterizedTypeTree) {
            ParameterizedTypeTree parameterizedType = (ParameterizedTypeTree)this.type;
            return ((TypeElement)((Object)((JCTree.JCTypeApply)parameterizedType).type.asElement())).getQualifiedName().toString();
        }
        return null;
    }

    @Override
    public TypeUse.TypeInternal getArgAt(int index) {
        ParameterizedTypeTree parameterizedType = (ParameterizedTypeTree)this.type;
        Tree type = parameterizedType.getTypeArguments().get(index);
        return new TreeTypeInternal(type, TreeTypeInternal.isNullable(type));
    }

    private static boolean isNullable(Tree type) {
        JCTree.JCExpression expr;
        Type typeMirror = ((JCTree)type).type;
        if (typeMirror instanceof Type.AnnotatedType) {
            Type.AnnotatedType abc = (Type.AnnotatedType)typeMirror;
            for (AnnotationMirror mirror : abc.getAnnotationMirrors()) {
                if (!mirror.getAnnotationType().toString().equals(TypeUse.NULLABLE)) continue;
                return true;
            }
        }
        if (type instanceof JCTree.JCTypeApply && (expr = ((JCTree.JCTypeApply)type).clazz) instanceof AnnotatedTypeTree) {
            AnnotatedTypeTree tree2 = (AnnotatedTypeTree)((Object)expr);
            for (AnnotationTree annotationTree : tree2.getAnnotations()) {
                if (!(annotationTree instanceof JCTree.JCAnnotation)) continue;
                JCTree.JCAnnotation jca = (JCTree.JCAnnotation)annotationTree;
                if (!jca.type.toString().equals(TypeUse.NULLABLE)) continue;
                return true;
            }
        }
        return false;
    }
}

