/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.netty.runtime;

import io.netty.channel.DefaultChannelId;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.quarkus.runtime.annotations.Recorder;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class NettyRecorder {
    private static final Logger log = Logger.getLogger(NettyRecorder.class);

    public void eagerlyInitChannelId() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                DefaultChannelId.newInstance();
                if (System.currentTimeMillis() - start > 1000L) {
                    log.warn((Object)("Netty DefaultChannelId initialization (with io.netty.machineId system property set to " + System.getProperty("io.netty.machineId") + ") took more than a second"));
                }
            }
        }).start();
    }

    public Supplier<EventLoopGroup> createEventLoop(final int nThreads) {
        return new Supplier<EventLoopGroup>(){
            volatile EventLoopGroup val;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EventLoopGroup get() {
                if (this.val == null) {
                    2 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.val == null) {
                            this.val = new NioEventLoopGroup(nThreads);
                        }
                    }
                }
                return this.val;
            }
        };
    }
}

