/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security.impl;

import java.util.Objects;
import javax.security.auth.Subject;

public final class CacheSubjectPair {
    private final Subject subject;
    private final String cacheName;
    private final int hashCode;

    CacheSubjectPair(Subject subject, String cacheName) {
        this.subject = subject;
        this.cacheName = cacheName;
        this.hashCode = this.computeHashCode();
    }

    private int computeHashCode() {
        return Objects.hash(this.subject, this.cacheName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheSubjectPair that = (CacheSubjectPair)o;
        return this.subject.equals(that.subject) && this.cacheName.equals(that.cacheName);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "CacheSubjectPair{cacheName=" + this.cacheName + ", subject=" + String.valueOf(this.subject) + "}";
    }
}

