/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalRolesConfigurationChildBuilder;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.Role;
import org.infinispan.security.impl.CacheRoleImpl;

public class GlobalRoleConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements GlobalRolesConfigurationChildBuilder,
Builder<Role> {
    private final Set<AuthorizationPermission> permissions = new HashSet<AuthorizationPermission>();
    private final GlobalAuthorizationConfigurationBuilder builder;
    private final String name;
    private boolean inheritable = true;
    private String description;
    private boolean implicit;

    public GlobalRoleConfigurationBuilder(String name, GlobalAuthorizationConfigurationBuilder builder) {
        super(builder.getGlobalConfig());
        this.builder = builder;
        this.name = name;
    }

    public AttributeSet attributes() {
        return AttributeSet.EMPTY;
    }

    public GlobalRoleConfigurationBuilder permission(String permission) {
        this.permissions.add(AuthorizationPermission.valueOf(permission));
        return this;
    }

    public GlobalRoleConfigurationBuilder permission(String ... permissions) {
        for (String permission : permissions) {
            this.permissions.add(AuthorizationPermission.valueOf(permission));
        }
        return this;
    }

    public GlobalRoleConfigurationBuilder permission(AuthorizationPermission permission) {
        this.permissions.add(permission);
        return this;
    }

    public GlobalRoleConfigurationBuilder permission(AuthorizationPermission ... permissions) {
        Collections.addAll(this.permissions, permissions);
        return this;
    }

    @Override
    public GlobalRoleConfigurationBuilder role(String name) {
        return this.builder.role(name);
    }

    @Override
    public GlobalRoleConfigurationBuilder inheritable(boolean inheritable) {
        this.inheritable = inheritable;
        return this;
    }

    @Override
    public GlobalRoleConfigurationBuilder description(String description) {
        this.description = description;
        return this;
    }

    public Role create() {
        return new CacheRoleImpl(this.name, this.description, this.implicit, this.inheritable, this.permissions);
    }

    public Builder<?> read(Role template, Combine combine) {
        this.permissions.clear();
        this.permissions.addAll(template.getPermissions());
        this.inheritable = template.isInheritable();
        this.description = template.getDescription();
        this.implicit = template.isImplicit();
        return this;
    }
}

