/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validate.validators;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.keycloak.provider.ConfiguredProvider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.validate.AbstractSimpleValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidatorConfig;

public class UriValidator
extends AbstractSimpleValidator
implements ConfiguredProvider {
    public static final UriValidator INSTANCE = new UriValidator();
    public static final String KEY_ALLOWED_SCHEMES = "allowedSchemes";
    public static final String KEY_ALLOW_FRAGMENT = "allowFragment";
    public static final String KEY_REQUIRE_VALID_URL = "requireValidUrl";
    public static final List<String> DEFAULT_ALLOWED_SCHEMES = Collections.unmodifiableList(Arrays.asList("http", "https"));
    public static final String MESSAGE_INVALID_URI = "error-invalid-uri";
    public static final String MESSAGE_INVALID_SCHEME = "error-invalid-uri-scheme";
    public static final String MESSAGE_INVALID_FRAGMENT = "error-invalid-uri-fragment";
    public static final boolean DEFAULT_ALLOW_FRAGMENT = true;
    public static final boolean DEFAULT_REQUIRE_VALID_URL = true;
    public static final String ID = "uri";
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public String getId() {
        return ID;
    }

    protected boolean skipValidation(Object value, ValidatorConfig config) {
        return false;
    }

    protected void doValidate(Object input, String inputHint, ValidationContext context, ValidatorConfig config) {
        if (input == null || input instanceof String && ((String)input).isEmpty()) {
            return;
        }
        try {
            URI uri = this.toUri(input);
            if (uri == null) {
                context.addError(new ValidationError(ID, inputHint, MESSAGE_INVALID_URI, new Object[]{input}));
            } else {
                HashSet<String> allowedSchemes = new HashSet<String>(config.getStringListOrDefault(KEY_ALLOWED_SCHEMES, DEFAULT_ALLOWED_SCHEMES));
                boolean allowFragment = config.getBooleanOrDefault(KEY_ALLOW_FRAGMENT, Boolean.valueOf(true));
                boolean requireValidUrl = config.getBooleanOrDefault(KEY_REQUIRE_VALID_URL, Boolean.valueOf(true));
                this.validateUri(uri, inputHint, context, allowedSchemes, allowFragment, requireValidUrl);
            }
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            context.addError(new ValidationError(ID, inputHint, MESSAGE_INVALID_URI, new Object[]{input, e.getMessage()}));
        }
    }

    private URI toUri(Object input) throws URISyntaxException {
        if (input instanceof String) {
            String uriString = (String)input;
            return new URI(uriString);
        }
        if (input instanceof URI) {
            URI uri = (URI)input;
            return uri;
        }
        if (input instanceof URL) {
            URL url = (URL)input;
            return url.toURI();
        }
        return null;
    }

    public boolean validateUri(URI uri, Set<String> allowedSchemes, boolean allowFragment, boolean requireValidUrl) {
        try {
            return this.validateUri(uri, "url", new ValidationContext(), allowedSchemes, allowFragment, requireValidUrl);
        }
        catch (MalformedURLException mue) {
            return false;
        }
    }

    public boolean validateUri(URI uri, String inputHint, ValidationContext context, Set<String> allowedSchemes, boolean allowFragment, boolean requireValidUrl) throws MalformedURLException {
        boolean valid = true;
        if (uri.getScheme() != null && !allowedSchemes.contains(uri.getScheme())) {
            context.addError(new ValidationError(ID, inputHint, MESSAGE_INVALID_SCHEME, new Object[]{uri, uri.getScheme()}));
            valid = false;
        }
        if (!allowFragment && uri.getFragment() != null) {
            context.addError(new ValidationError(ID, inputHint, MESSAGE_INVALID_FRAGMENT, new Object[]{uri, uri.getFragment()}));
            valid = false;
        }
        if (requireValidUrl && valid) {
            uri.toURL();
        }
        return valid;
    }

    public String getHelpText() {
        return "Uri Validator";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(KEY_ALLOWED_SCHEMES);
        property.setLabel("Allowed schemes");
        property.setHelpText("Allowed URL schemes. Defaults to 'http' and 'https' as only allowed schemes");
        property.setType("MultivaluedString");
        property.setDefaultValue(DEFAULT_ALLOWED_SCHEMES);
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName(KEY_ALLOW_FRAGMENT);
        property.setLabel("Allow fragment");
        property.setHelpText("Specify if allow URL with the URI fragment. It is true by default");
        property.setType("boolean");
        property.setDefaultValue((Object)true);
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName(KEY_REQUIRE_VALID_URL);
        property.setLabel("Require Valid URL");
        property.setHelpText("Checks if the specified URL is valid URL. It is true by default");
        property.setType("boolean");
        property.setDefaultValue((Object)true);
        configProperties.add(property);
    }
}

