/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.keycloak.common.util.Base64Url;
import org.keycloak.jose.JOSE;
import org.keycloak.jose.jwe.JWE;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.util.JsonSerialization;

public class JOSEParser {
    public static JOSE parse(String jwt) {
        JsonNode header;
        String[] parts = jwt.split("\\.");
        if (parts.length == 0) {
            throw new RuntimeException("Could not infer header from JWT");
        }
        try {
            header = JsonSerialization.readValue(Base64Url.decode((String)parts[0]), JsonNode.class);
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to parse JWT header", cause);
        }
        if (header.has("enc")) {
            return new JWE(jwt);
        }
        try {
            return new JWSInput(jwt);
        }
        catch (JWSInputException cause) {
            throw new RuntimeException("Failed to build JWS", cause);
        }
    }
}

