/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.truststore;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.truststore.TruststoreProvider;
import org.keycloak.truststore.TruststoreProviderFactory;

public class JSSETruststoreConfigurator {
    private TruststoreProvider provider;
    private volatile SSLSocketFactory sslFactory;
    private volatile TrustManager[] tm;

    public JSSETruststoreConfigurator(KeycloakSession session) {
        KeycloakSessionFactory factory = session.getKeycloakSessionFactory();
        TruststoreProviderFactory truststoreFactory = (TruststoreProviderFactory)factory.getProviderFactory(TruststoreProvider.class, "file");
        this.provider = (TruststoreProvider)truststoreFactory.create(session);
        if (this.provider != null && this.provider.getTruststore() == null) {
            this.provider = null;
        }
    }

    public JSSETruststoreConfigurator(TruststoreProvider provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLSocketFactory getSSLSocketFactory() {
        if (this.provider == null) {
            return null;
        }
        if (this.sslFactory == null) {
            JSSETruststoreConfigurator jSSETruststoreConfigurator = this;
            synchronized (jSSETruststoreConfigurator) {
                if (this.sslFactory == null) {
                    try {
                        SSLContext sslctx = SSLContext.getInstance("TLS");
                        sslctx.init(null, this.getTrustManagers(), null);
                        this.sslFactory = sslctx.getSocketFactory();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to initialize SSLContext: ", e);
                    }
                }
            }
        }
        return this.sslFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrustManager[] getTrustManagers() {
        if (this.provider == null) {
            return null;
        }
        if (this.tm == null) {
            JSSETruststoreConfigurator jSSETruststoreConfigurator = this;
            synchronized (jSSETruststoreConfigurator) {
                if (this.tm == null) {
                    TrustManagerFactory tmf = null;
                    try {
                        tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        tmf.init(this.provider.getTruststore());
                        this.tm = tmf.getTrustManagers();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to initialize TrustManager: ", e);
                    }
                }
            }
        }
        return this.tm;
    }

    public TruststoreProvider getProvider() {
        return this.provider;
    }
}

