/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.google;

import com.fasterxml.jackson.databind.JsonNode;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.util.List;
import org.keycloak.broker.oidc.OIDCIdentityProvider;
import org.keycloak.broker.oidc.OIDCIdentityProviderConfig;
import org.keycloak.broker.provider.AuthenticationRequest;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.broker.social.SocialIdentityProvider;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.TokenExchangeContext;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.social.google.GoogleIdentityProviderConfig;

public class GoogleIdentityProvider
extends OIDCIdentityProvider
implements SocialIdentityProvider<OIDCIdentityProviderConfig> {
    public static final String AUTH_URL = "https://accounts.google.com/o/oauth2/v2/auth";
    public static final String TOKEN_URL = "https://oauth2.googleapis.com/token";
    public static final String PROFILE_URL = "https://openidconnect.googleapis.com/v1/userinfo";
    public static final String TOKEN_INFO_URL = "https://oauth2.googleapis.com/tokeninfo";
    public static final String DEFAULT_SCOPE = "openid profile email";
    private static final String OIDC_PARAMETER_HOSTED_DOMAINS = "hd";
    private static final String OIDC_PARAMETER_ACCESS_TYPE = "access_type";
    private static final String ACCESS_TYPE_OFFLINE = "offline";

    public GoogleIdentityProvider(KeycloakSession session, GoogleIdentityProviderConfig config) {
        super(session, config);
        config.setAuthorizationUrl(AUTH_URL);
        config.setTokenUrl(TOKEN_URL);
        config.setUserInfoUrl(PROFILE_URL);
    }

    @Override
    protected String getDefaultScopes() {
        return DEFAULT_SCOPE;
    }

    @Override
    protected String getUserInfoUrl() {
        ClientConnection connection;
        String uri = super.getUserInfoUrl();
        if (((GoogleIdentityProviderConfig)this.getConfig()).isUserIp() && (connection = this.session.getContext().getConnection()) != null && connection.getRemoteAddr() != null) {
            uri = KeycloakUriBuilder.fromUri((String)super.getUserInfoUrl()).queryParam("userIp", new Object[]{connection.getRemoteAddr()}).build(new Object[0]).toString();
        }
        logger.debugv("GOOGLE userInfoUrl: {0}", (Object)uri);
        return uri;
    }

    @Override
    protected boolean supportsExternalExchange() {
        return true;
    }

    @Override
    public boolean isIssuer(String issuer, MultivaluedMap<String, String> params) {
        String requestedIssuer = (String)params.getFirst((Object)"subject_issuer");
        if (requestedIssuer == null) {
            requestedIssuer = issuer;
        }
        return requestedIssuer.equals(((OIDCIdentityProviderConfig)this.getConfig()).getAlias());
    }

    @Override
    protected BrokeredIdentityContext exchangeExternalTokenV1Impl(EventBuilder event, MultivaluedMap<String, String> params) {
        return this.exchangeExternalUserInfoValidationOnly(event, params);
    }

    @Override
    protected BrokeredIdentityContext exchangeExternalTokenV2Impl(TokenExchangeContext tokenExchangeContext) {
        try {
            JsonNode tokenInfo = SimpleHttp.doGet((String)TOKEN_INFO_URL, (KeycloakSession)this.session).header("Authorization", "Bearer " + tokenExchangeContext.getParams().getSubjectToken()).asJson();
            if (tokenInfo == null || !tokenInfo.has("aud") || !tokenInfo.get("aud").asText().equals(((OIDCIdentityProviderConfig)this.getConfig()).getClientId())) {
                logger.tracef("Invalid response or unmatching audience from the token-info endpoint from Google. Expected audience '%s' . Token info response: %s", (Object)((OIDCIdentityProviderConfig)this.getConfig()).getClientId(), (Object)tokenInfo);
                EventBuilder event = tokenExchangeContext.getEvent();
                event.detail("reason", "Google token validation failed");
                event.error("invalid_token");
                throw new ErrorResponseException("invalid_token", "Google token validation failed", Response.Status.BAD_REQUEST);
            }
        }
        catch (ErrorResponseException ere) {
            throw ere;
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not verify token info from google.", (Throwable)e);
        }
        return this.exchangeExternalUserInfoValidationOnly(tokenExchangeContext.getEvent(), (MultivaluedMap<String, String>)tokenExchangeContext.getFormParams());
    }

    @Override
    protected UriBuilder createAuthorizationUrl(AuthenticationRequest request) {
        UriBuilder uriBuilder = super.createAuthorizationUrl(request);
        GoogleIdentityProviderConfig googleConfig = (GoogleIdentityProviderConfig)this.getConfig();
        String hostedDomain = googleConfig.getHostedDomain();
        if (hostedDomain != null) {
            uriBuilder.queryParam(OIDC_PARAMETER_HOSTED_DOMAINS, new Object[]{hostedDomain});
        }
        if (googleConfig.isOfflineAccess()) {
            uriBuilder.queryParam(OIDC_PARAMETER_ACCESS_TYPE, new Object[]{ACCESS_TYPE_OFFLINE});
        }
        return uriBuilder;
    }

    @Override
    protected JsonWebToken validateToken(String encodedToken, boolean ignoreAudience) {
        boolean anyHostedDomain;
        JsonWebToken token = super.validateToken(encodedToken, ignoreAudience);
        String hostedDomain = ((GoogleIdentityProviderConfig)this.getConfig()).getHostedDomain();
        boolean bl = anyHostedDomain = hostedDomain == null || "*".equals(hostedDomain);
        if (anyHostedDomain) {
            return token;
        }
        Object receivedHdParam = token.getOtherClaims().get(OIDC_PARAMETER_HOSTED_DOMAINS);
        if (receivedHdParam == null) {
            throw new IdentityBrokerException("Identity token does not contain hosted domain parameter.");
        }
        if (List.of(hostedDomain.split(",")).contains(receivedHdParam)) {
            return token;
        }
        throw new IdentityBrokerException("Hosted domain does not match.");
    }
}

