/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import java.util.Collections;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProviderFactory;
import org.keycloak.services.clientpolicy.executor.RejectResourceOwnerPasswordCredentialsGrantExecutor;

public class RejectResourceOwnerPasswordCredentialsGrantExecutorFactory
implements ClientPolicyExecutorProviderFactory {
    public static final String PROVIDER_ID = "reject-ropc-grant";
    public static final String AUTO_CONFIGURE = "auto-configure";
    private static final ProviderConfigProperty AUTO_CONFIGURE_PROPERTY = new ProviderConfigProperty("auto-configure", "Auto-configure", "If On, then the during client creation or update, the configuration of the client will be auto-configured to reject a resource owner password credentials grant.", "boolean", (Object)false);

    public ClientPolicyExecutorProvider create(KeycloakSession session) {
        return new RejectResourceOwnerPasswordCredentialsGrantExecutor(session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "It makes keycloak to reject a resource owner password credentials grant.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return Collections.singletonList(AUTO_CONFIGURE_PROPERTY);
    }
}

