/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.ws.rs.core.MultivaluedMap;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.ClientCRUDContext;
import org.keycloak.services.clientpolicy.context.ResourceOwnerPasswordCredentialsContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class RejectResourceOwnerPasswordCredentialsGrantExecutor
implements ClientPolicyExecutorProvider<Configuration> {
    private final KeycloakSession session;
    private Configuration configuration;

    public RejectResourceOwnerPasswordCredentialsGrantExecutor(KeycloakSession session) {
        this.session = session;
    }

    public void setupConfiguration(Configuration config) {
        this.configuration = config;
    }

    public Class<Configuration> getExecutorConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "reject-ropc-grant";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case REGISTER: 
            case UPDATE: {
                ClientCRUDContext clientUpdateContext = (ClientCRUDContext)context;
                this.autoConfigure(clientUpdateContext.getProposedClientRepresentation());
                this.validate(clientUpdateContext.getProposedClientRepresentation());
                break;
            }
            case RESOURCE_OWNER_PASSWORD_CREDENTIALS_REQUEST: {
                ResourceOwnerPasswordCredentialsContext ropcContext = (ResourceOwnerPasswordCredentialsContext)context;
                this.executeOnAuthorizationRequest(ropcContext.getParams());
                return;
            }
            default: {
                return;
            }
        }
    }

    private void autoConfigure(ClientRepresentation rep) {
        if (this.configuration.isAutoConfigure().booleanValue()) {
            rep.setDirectAccessGrantsEnabled(Boolean.FALSE);
        }
    }

    private void validate(ClientRepresentation rep) throws ClientPolicyException {
        boolean isResourceOwnerPasswordCredentialsGrantEnabled = rep.isDirectAccessGrantsEnabled();
        if (!isResourceOwnerPasswordCredentialsGrantEnabled) {
            return;
        }
        throw new ClientPolicyException("invalid_client_metadata", "Invalid client metadata: resource owner password credentials grant enabled");
    }

    private void executeOnAuthorizationRequest(MultivaluedMap<String, String> params) throws ClientPolicyException {
        throw new ClientPolicyException("invalid_grant", "resource owner password credentials grant is prohibited.");
    }

    public static class Configuration
    extends ClientPolicyExecutorConfigurationRepresentation {
        @JsonProperty(value="auto-configure")
        protected Boolean autoConfigure;

        public Boolean isAutoConfigure() {
            return this.autoConfigure;
        }

        public void setAutoConfigure(Boolean autoConfigure) {
            this.autoConfigure = autoConfigure;
        }
    }
}

