/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants.ciba.channel;

import java.util.List;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.protocol.oidc.grants.ciba.channel.AuthenticationChannelProvider;
import org.keycloak.protocol.oidc.grants.ciba.channel.AuthenticationChannelProviderFactory;
import org.keycloak.protocol.oidc.grants.ciba.channel.HttpAuthenticationChannelProvider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class HttpAuthenticationChannelProviderFactory
implements AuthenticationChannelProviderFactory {
    public static final String PROVIDER_ID = "ciba-http-auth-channel";
    protected String httpAuthenticationChannelUri;

    public AuthenticationChannelProvider create(KeycloakSession session) {
        return new HttpAuthenticationChannelProvider(session, this.httpAuthenticationChannelUri);
    }

    public void init(Config.Scope config) {
        this.httpAuthenticationChannelUri = config.get("httpAuthenticationChannelUri");
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name("httpAuthenticationChannelUri").type("string").helpText("The HTTP(S) URI of the authentication channel.").add().build();
    }
}

