/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc;

import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.authentication.ClientAuthenticator;
import org.keycloak.authentication.ClientAuthenticatorFactory;
import org.keycloak.authentication.authenticators.util.LoAUtil;
import org.keycloak.common.Profile;
import org.keycloak.crypto.CekManagementProvider;
import org.keycloak.crypto.ClientSignatureVerifierProvider;
import org.keycloak.crypto.ContentEncryptionProvider;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.jose.jws.Algorithm;
import org.keycloak.models.CibaConfig;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.protocol.oidc.endpoints.AuthorizationEndpoint;
import org.keycloak.protocol.oidc.endpoints.TokenEndpoint;
import org.keycloak.protocol.oidc.grants.OAuth2GrantType;
import org.keycloak.protocol.oidc.grants.ciba.CibaGrantType;
import org.keycloak.protocol.oidc.grants.device.endpoints.DeviceEndpoint;
import org.keycloak.protocol.oidc.par.endpoints.ParEndpoint;
import org.keycloak.protocol.oidc.representations.MTLSEndpointAliases;
import org.keycloak.protocol.oidc.representations.OIDCConfigurationRepresentation;
import org.keycloak.protocol.oidc.utils.AcrUtils;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.services.Urls;
import org.keycloak.services.clientregistration.ClientRegistrationService;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.util.DPoPUtil;
import org.keycloak.urls.UrlType;
import org.keycloak.util.JsonSerialization;
import org.keycloak.wellknown.WellKnownProvider;

public class OIDCWellKnownProvider
implements WellKnownProvider {
    public static final List<String> DEFAULT_RESPONSE_TYPES_SUPPORTED = OIDCWellKnownProvider.list("code", "none", "id_token", "token", "id_token token", "code id_token", "code token", "code id_token token");
    public static final List<String> DEFAULT_SUBJECT_TYPES_SUPPORTED = OIDCWellKnownProvider.list("public", "pairwise");
    public static final List<String> DEFAULT_RESPONSE_MODES_SUPPORTED = OIDCWellKnownProvider.list("query", "fragment", "form_post", "query.jwt", "fragment.jwt", "form_post.jwt", "jwt");
    public static final List<String> DEFAULT_CLIENT_AUTH_SIGNING_ALG_VALUES_SUPPORTED = OIDCWellKnownProvider.list(Algorithm.RS256.toString());
    public static final List<String> DEFAULT_CLAIMS_SUPPORTED = OIDCWellKnownProvider.list("aud", "sub", "iss", "auth_time", "name", "given_name", "family_name", "preferred_username", "email", "acr");
    public static final List<String> DEFAULT_CLAIM_TYPES_SUPPORTED = OIDCWellKnownProvider.list("normal");
    public static final List<String> DEFAULT_CODE_CHALLENGE_METHODS_SUPPORTED = OIDCWellKnownProvider.list("plain", "S256");
    public static final List<String> DEFAULT_PROMPT_VALUES_SUPPORTED = OIDCWellKnownProvider.list("none", "login", "consent");
    private final KeycloakSession session;
    private final Map<String, Object> openidConfigOverride;
    private final boolean includeClientScopes;

    public OIDCWellKnownProvider(KeycloakSession session, Map<String, Object> openidConfigOverride, boolean includeClientScopes) {
        this.session = session;
        this.openidConfigOverride = openidConfigOverride;
        this.includeClientScopes = includeClientScopes;
    }

    @Override
    public Object getConfig() {
        KeycloakUriInfo frontendUriInfo = this.session.getContext().getUri(UrlType.FRONTEND);
        KeycloakUriInfo backendUriInfo = this.session.getContext().getUri(UrlType.BACKEND);
        RealmModel realm = this.session.getContext().getRealm();
        UriBuilder frontendUriBuilder = RealmsResource.protocolUrl((UriInfo)frontendUriInfo);
        UriBuilder backendUriBuilder = RealmsResource.protocolUrl((UriInfo)backendUriInfo);
        OIDCConfigurationRepresentation config = new OIDCConfigurationRepresentation();
        config.setIssuer(Urls.realmIssuer(frontendUriInfo.getBaseUri(), realm.getName()));
        config.setAuthorizationEndpoint(frontendUriBuilder.clone().path(OIDCLoginProtocolService.class, "auth").build(new Object[]{realm.getName(), "openid-connect"}).toString());
        config.setTokenEndpoint(backendUriBuilder.clone().path(OIDCLoginProtocolService.class, "token").build(new Object[]{realm.getName(), "openid-connect"}).toString());
        config.setIntrospectionEndpoint(backendUriBuilder.clone().path(OIDCLoginProtocolService.class, "token").path(TokenEndpoint.class, "introspect").build(new Object[]{realm.getName(), "openid-connect"}).toString());
        config.setUserinfoEndpoint(backendUriBuilder.clone().path(OIDCLoginProtocolService.class, "issueUserInfo").build(new Object[]{realm.getName(), "openid-connect"}).toString());
        config.setLogoutEndpoint(frontendUriBuilder.clone().path(OIDCLoginProtocolService.class, "logout").build(new Object[]{realm.getName(), "openid-connect"}).toString());
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DEVICE_FLOW)) {
            config.setDeviceAuthorizationEndpoint(frontendUriBuilder.clone().path(OIDCLoginProtocolService.class, "auth").path(AuthorizationEndpoint.class, "authorizeDevice").path(DeviceEndpoint.class, "handleDeviceRequest").build(new Object[]{realm.getName(), "openid-connect"}).toString());
        }
        URI jwksUri = backendUriBuilder.clone().path(OIDCLoginProtocolService.class, "certs").build(new Object[]{realm.getName(), "openid-connect"});
        config.setJwksUri(jwksUri.toString());
        config.setCheckSessionIframe(frontendUriBuilder.clone().path(OIDCLoginProtocolService.class, "getLoginStatusIframe").build(new Object[]{realm.getName(), "openid-connect"}).toString());
        config.setRegistrationEndpoint(RealmsResource.clientRegistrationUrl((UriInfo)backendUriInfo).path(ClientRegistrationService.class, "provider").build(new Object[]{realm.getName(), "openid-connect"}).toString());
        config.setIdTokenSigningAlgValuesSupported(this.getSupportedSigningAlgorithms(false));
        config.setIdTokenEncryptionAlgValuesSupported(this.getSupportedEncryptionAlg(false));
        config.setIdTokenEncryptionEncValuesSupported(this.getSupportedEncryptionEnc(false));
        config.setUserInfoSigningAlgValuesSupported(this.getSupportedSigningAlgorithms(true));
        config.setUserInfoEncryptionAlgValuesSupported(this.getSupportedEncryptionAlgorithms());
        config.setUserInfoEncryptionEncValuesSupported(this.getSupportedContentEncryptionAlgorithms());
        config.setRequestObjectSigningAlgValuesSupported(this.getSupportedClientSigningAlgorithms(true));
        config.setRequestObjectEncryptionAlgValuesSupported(this.getSupportedEncryptionAlgorithms());
        config.setRequestObjectEncryptionEncValuesSupported(this.getSupportedContentEncryptionAlgorithms());
        config.setResponseTypesSupported(DEFAULT_RESPONSE_TYPES_SUPPORTED);
        config.setSubjectTypesSupported(DEFAULT_SUBJECT_TYPES_SUPPORTED);
        config.setResponseModesSupported(DEFAULT_RESPONSE_MODES_SUPPORTED);
        config.setGrantTypesSupported(this.getGrantTypesSupported());
        config.setAcrValuesSupported(this.getAcrValuesSupported(realm));
        config.setPromptValuesSupported(this.getPromptValuesSupported(realm));
        config.setTokenEndpointAuthMethodsSupported(this.getClientAuthMethodsSupported());
        config.setTokenEndpointAuthSigningAlgValuesSupported(this.getSupportedClientSigningAlgorithms(false));
        config.setIntrospectionEndpointAuthMethodsSupported(this.getClientAuthMethodsSupported());
        config.setIntrospectionEndpointAuthSigningAlgValuesSupported(this.getSupportedClientSigningAlgorithms(false));
        config.setAuthorizationSigningAlgValuesSupported(this.getSupportedSigningAlgorithms(false));
        config.setAuthorizationEncryptionAlgValuesSupported(this.getSupportedEncryptionAlg(false));
        config.setAuthorizationEncryptionEncValuesSupported(this.getSupportedEncryptionEnc(false));
        config.setClaimsSupported(DEFAULT_CLAIMS_SUPPORTED);
        config.setClaimTypesSupported(DEFAULT_CLAIM_TYPES_SUPPORTED);
        config.setClaimsParameterSupported(Boolean.valueOf(true));
        if (this.includeClientScopes) {
            List scopeNames = realm.getClientScopesStream().filter(clientScope -> Objects.equals("openid-connect", clientScope.getProtocol())).map(ClientScopeModel::getName).collect(Collectors.toList());
            if (!scopeNames.contains("openid")) {
                scopeNames.add(0, "openid");
            }
            config.setScopesSupported(scopeNames);
        }
        config.setRequestParameterSupported(Boolean.valueOf(true));
        config.setRequestUriParameterSupported(Boolean.valueOf(true));
        config.setRequireRequestUriRegistration(Boolean.valueOf(true));
        config.setCodeChallengeMethodsSupported(DEFAULT_CODE_CHALLENGE_METHODS_SUPPORTED);
        config.setTlsClientCertificateBoundAccessTokens(Boolean.valueOf(true));
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DPOP)) {
            config.setDpopSigningAlgValuesSupported(new ArrayList<String>(DPoPUtil.DPOP_SUPPORTED_ALGS));
        }
        URI revocationEndpoint = frontendUriBuilder.clone().path(OIDCLoginProtocolService.class, "revoke").build(new Object[]{realm.getName(), "openid-connect"});
        config.setRevocationEndpoint(revocationEndpoint.toString());
        config.setRevocationEndpointAuthMethodsSupported(this.getClientAuthMethodsSupported());
        config.setRevocationEndpointAuthSigningAlgValuesSupported(this.getSupportedClientSigningAlgorithms(false));
        config.setBackchannelLogoutSupported(Boolean.valueOf(true));
        config.setBackchannelLogoutSessionSupported(Boolean.valueOf(true));
        config.setBackchannelTokenDeliveryModesSupported(CibaConfig.CIBA_SUPPORTED_MODES);
        config.setBackchannelAuthenticationEndpoint(CibaGrantType.authorizationUrl(backendUriInfo.getBaseUriBuilder()).build(new Object[]{realm.getName()}).toString());
        config.setBackchannelAuthenticationRequestSigningAlgValuesSupported(this.getSupportedBackchannelAuthenticationRequestSigningAlgorithms());
        config.setPushedAuthorizationRequestEndpoint(ParEndpoint.parUrl(backendUriInfo.getBaseUriBuilder()).build(new Object[]{realm.getName()}).toString());
        config.setRequirePushedAuthorizationRequests(Boolean.FALSE);
        MTLSEndpointAliases mtlsEndpointAliases = this.getMtlsEndpointAliases(config);
        config.setMtlsEndpointAliases(mtlsEndpointAliases);
        config.setAuthorizationResponseIssParameterSupported(Boolean.valueOf(true));
        config = this.checkConfigOverride(config);
        return config;
    }

    protected List<String> getPromptValuesSupported(RealmModel realm) {
        ArrayList<String> prompts = new ArrayList<String>(DEFAULT_PROMPT_VALUES_SUPPORTED);
        if (realm.isRegistrationAllowed()) {
            prompts.add("create");
        }
        return prompts;
    }

    public void close() {
    }

    private static List<String> list(String ... values) {
        return Arrays.asList(values);
    }

    private List<String> getClientAuthMethodsSupported() {
        return this.session.getKeycloakSessionFactory().getProviderFactoriesStream(ClientAuthenticator.class).map(ClientAuthenticatorFactory.class::cast).map(caf -> caf.getProtocolAuthenticatorMethods("openid-connect")).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<String> getSupportedAlgorithms(Class<? extends Provider> clazz, boolean includeNone) {
        Stream<String> supportedAlgorithms = this.session.getKeycloakSessionFactory().getProviderFactoriesStream(clazz).map(ProviderFactory::getId);
        if (includeNone) {
            supportedAlgorithms = Stream.concat(supportedAlgorithms, Stream.of("none"));
        }
        return supportedAlgorithms.collect(Collectors.toList());
    }

    private List<String> getSupportedAsymmetricAlgorithms() {
        return this.getSupportedAlgorithms(SignatureProvider.class, false).stream().map(algorithm -> new AbstractMap.SimpleEntry<String, SignatureProvider>((String)algorithm, (SignatureProvider)this.session.getProvider(SignatureProvider.class, algorithm))).filter(entry -> entry.getValue() != null).filter(entry -> ((SignatureProvider)entry.getValue()).isAsymmetricAlgorithm()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private List<String> getSupportedSigningAlgorithms(boolean includeNone) {
        return this.getSupportedAlgorithms(SignatureProvider.class, includeNone);
    }

    private List<String> getSupportedClientSigningAlgorithms(boolean includeNone) {
        return this.getSupportedAlgorithms(ClientSignatureVerifierProvider.class, includeNone);
    }

    private List<String> getSupportedContentEncryptionAlgorithms() {
        return this.getSupportedAlgorithms(ContentEncryptionProvider.class, false);
    }

    private List<String> getGrantTypesSupported() {
        Stream<String> supportedGrantTypes = this.session.getKeycloakSessionFactory().getProviderFactoriesStream(OAuth2GrantType.class).map(ProviderFactory::getId);
        return Stream.concat(supportedGrantTypes, Stream.of("implicit")).sorted().collect(Collectors.toList());
    }

    private List<String> getAcrValuesSupported(RealmModel realm) {
        Map<String, Integer> realmAcrLoaMap = AcrUtils.getAcrLoaMap(realm);
        ArrayList<String> result = new ArrayList<String>(realmAcrLoaMap.keySet());
        result.addAll(LoAUtil.getLoAConfiguredInRealmBrowserFlow(realm).map(String::valueOf).collect(Collectors.toList()));
        return result;
    }

    private List<String> getSupportedEncryptionAlgorithms() {
        return this.getSupportedAlgorithms(CekManagementProvider.class, false);
    }

    private List<String> getSupportedBackchannelAuthenticationRequestSigningAlgorithms() {
        return this.getSupportedAsymmetricAlgorithms();
    }

    private List<String> getSupportedEncryptionAlg(boolean includeNone) {
        return this.getSupportedAlgorithms(CekManagementProvider.class, includeNone);
    }

    private List<String> getSupportedEncryptionEnc(boolean includeNone) {
        return this.getSupportedAlgorithms(ContentEncryptionProvider.class, includeNone);
    }

    protected MTLSEndpointAliases getMtlsEndpointAliases(OIDCConfigurationRepresentation config) {
        MTLSEndpointAliases mtls_endpoints = new MTLSEndpointAliases();
        mtls_endpoints.setTokenEndpoint(config.getTokenEndpoint());
        mtls_endpoints.setRevocationEndpoint(config.getRevocationEndpoint());
        mtls_endpoints.setIntrospectionEndpoint(config.getIntrospectionEndpoint());
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DEVICE_FLOW)) {
            mtls_endpoints.setDeviceAuthorizationEndpoint(config.getDeviceAuthorizationEndpoint());
        }
        mtls_endpoints.setRegistrationEndpoint(config.getRegistrationEndpoint());
        mtls_endpoints.setUserInfoEndpoint(config.getUserinfoEndpoint());
        mtls_endpoints.setBackchannelAuthenticationEndpoint(config.getBackchannelAuthenticationEndpoint());
        mtls_endpoints.setPushedAuthorizationRequestEndpoint(config.getPushedAuthorizationRequestEndpoint());
        return mtls_endpoints;
    }

    private OIDCConfigurationRepresentation checkConfigOverride(OIDCConfigurationRepresentation config) {
        if (this.openidConfigOverride != null) {
            Map asMap = (Map)JsonSerialization.mapper.convertValue((Object)config, Map.class);
            asMap.putAll(this.openidConfigOverride);
            return (OIDCConfigurationRepresentation)JsonSerialization.mapper.convertValue((Object)asMap, OIDCConfigurationRepresentation.class);
        }
        return config;
    }
}

