/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.ByteVector;

public class S8Vector
extends ByteVector<Byte> {
    public S8Vector() {
        this.data = empty;
    }

    public S8Vector(int size, byte value) {
        byte[] array = new byte[size];
        this.data = array;
        if (value != 0) {
            while (--size >= 0) {
                array[size] = value;
            }
        }
    }

    public S8Vector(int size) {
        this(new byte[size]);
    }

    public S8Vector(byte[] data) {
        this.data = data;
    }

    public S8Vector(byte[] values, int offset, int length) {
        this(length);
        System.arraycopy(values, offset, this.data, 0, length);
    }

    @Override
    public final int getIntRaw(int index) {
        return this.data[index];
    }

    @Override
    public final Byte get(int index) {
        return this.data[this.effectiveIndex(index)];
    }

    @Override
    public final Byte getRaw(int index) {
        return this.data[index];
    }

    @Override
    public final void setRaw(int index, Byte value) {
        this.data[index] = value;
    }

    @Override
    protected S8Vector newInstance(int newLength) {
        return new S8Vector(newLength < 0 ? this.data : new byte[newLength]);
    }

    public static S8Vector castOrNull(Object obj) {
        if (obj instanceof byte[]) {
            return new S8Vector((byte[])obj);
        }
        if (obj instanceof S8Vector) {
            return (S8Vector)obj;
        }
        return null;
    }

    public static S8Vector cast(Object value) {
        S8Vector vec = S8Vector.castOrNull(value);
        if (vec == null) {
            String msg = value == null ? "cannot convert null to S8Vector" : "cannot convert a " + value.getClass().getName() + " to S8Vector";
            throw new ClassCastException(msg);
        }
        return vec;
    }

    @Override
    public int getElementKind() {
        return 18;
    }

    @Override
    public String getTag() {
        return "s8";
    }

    public int compareTo(Object obj) {
        return S8Vector.compareToInt(this, (S8Vector)obj);
    }
}

