/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.template_engine;

import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;
import org.openstreetmap.josm.tools.template_engine.TemplateEntry;

public class SearchExpressionCondition
implements TemplateEntry {
    private final SearchCompiler.Match condition;
    private final TemplateEntry text;

    public SearchExpressionCondition(SearchCompiler.Match condition, TemplateEntry text) {
        this.condition = condition;
        this.text = text;
    }

    @Override
    public void appendText(StringBuilder result, TemplateEngineDataProvider dataProvider) {
        this.text.appendText(result, dataProvider);
    }

    @Override
    public boolean isValid(TemplateEngineDataProvider dataProvider) {
        return dataProvider.evaluateCondition(this.condition);
    }

    public String toString() {
        return this.condition + " '" + this.text + '\'';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SearchExpressionCondition other = (SearchExpressionCondition)obj;
        if (this.condition == null ? other.condition != null : !this.condition.equals(other.condition)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }
}

