/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.StreamProgressUpdater;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class ProgressInputStream
extends InputStream {
    private final StreamProgressUpdater updater;
    private final InputStream in;

    public ProgressInputStream(InputStream in, long size, ProgressMonitor progressMonitor) {
        CheckParameterUtil.ensureParameterNotNull(in, "in");
        this.updater = new StreamProgressUpdater(size, Optional.ofNullable(progressMonitor).orElse(NullProgressMonitor.INSTANCE), I18n.tr("Downloading data...", new Object[0]));
        this.in = in;
    }

    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            this.updater.finishTask();
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.in.read(b, off, len);
        if (read != -1) {
            this.updater.advanceTicker(read);
        } else {
            this.updater.finishTask();
        }
        return read;
    }

    @Override
    public int read() throws IOException {
        int read = this.in.read();
        if (read != -1) {
            this.updater.advanceTicker(1);
        } else {
            this.updater.finishTask();
        }
        return read;
    }
}

