/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.layer.gpx.ConvertToDataLayerAction;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;

public class ConvertFromMarkerLayerAction
extends ConvertToDataLayerAction<MarkerLayer> {
    public ConvertFromMarkerLayerAction(MarkerLayer layer) {
        super(layer);
    }

    @Override
    public DataSet convert() {
        DataSet ds = new DataSet();
        for (Marker marker : ((MarkerLayer)this.layer).data) {
            Node node = new Node(marker.getCoor());
            List<String> mapping = Config.getPref().getList("gpx.to-osm-mapping", Arrays.asList("name", "name", "desc", "description", "cmt", "note", "src", "source", "sym", "gpxicon"));
            if (mapping.size() % 2 == 0) {
                Iterator it = mapping.iterator();
                while (it.hasNext()) {
                    String gpxKey = (String)it.next();
                    String osmKey = (String)it.next();
                    Optional.ofNullable(marker.getTemplateValue(gpxKey, false)).map(String::valueOf).ifPresent(s -> node.put(osmKey, (String)s));
                }
            } else {
                Logging.warn("Invalid gpx.to-osm-mapping Einstein setting: expecting even number of entries");
            }
            ds.addPrimitive(node);
        }
        return ds;
    }
}

