/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset.query;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.gui.dialogs.changeset.query.RestrictionPanel;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;

public class OpenAndCloseStateRestrictionPanel
extends JPanel
implements RestrictionPanel {
    private static final String PREF_ROOT = "changeset-query.advanced.open-restrictions";
    private static final String PREF_QUERY_TYPE = "changeset-query.advanced.open-restrictions.query-type";
    private final JRadioButton rbOpenOnly = new JRadioButton();
    private final JRadioButton rbClosedOnly = new JRadioButton();
    private final JRadioButton rbBoth = new JRadioButton();

    public OpenAndCloseStateRestrictionPanel() {
        this.build();
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 0.0;
        this.add((Component)this.rbOpenOnly, gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.add((Component)new JMultilineLabel(I18n.tr("Query open changesets only", new Object[0])), gc);
        gc.gridy = 1;
        gc.gridx = 0;
        gc.weightx = 0.0;
        this.add((Component)this.rbClosedOnly, gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.add((Component)new JMultilineLabel(I18n.tr("Query closed changesets only", new Object[0])), gc);
        gc.gridy = 2;
        gc.gridx = 0;
        gc.weightx = 0.0;
        this.add((Component)this.rbBoth, gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.add((Component)new JMultilineLabel(I18n.tr("Query both open and closed changesets", new Object[0])), gc);
        ButtonGroup bgRestrictions = new ButtonGroup();
        bgRestrictions.add(this.rbBoth);
        bgRestrictions.add(this.rbClosedOnly);
        bgRestrictions.add(this.rbOpenOnly);
    }

    public void startUserInput() {
        this.restoreFromSettings();
    }

    @Override
    public void fillInQuery(ChangesetQuery query) {
        if (this.rbBoth.isSelected()) {
            query.beingClosed(true);
            query.beingOpen(true);
        } else if (this.rbOpenOnly.isSelected()) {
            query.beingOpen(true);
        } else if (this.rbClosedOnly.isSelected()) {
            query.beingClosed(true);
        }
    }

    public void rememberSettings() {
        if (this.rbBoth.isSelected()) {
            Config.getPref().put(PREF_QUERY_TYPE, "both");
        } else if (this.rbOpenOnly.isSelected()) {
            Config.getPref().put(PREF_QUERY_TYPE, "open");
        } else if (this.rbClosedOnly.isSelected()) {
            Config.getPref().put(PREF_QUERY_TYPE, "closed");
        }
    }

    public void restoreFromSettings() {
        String v = Config.getPref().get(PREF_QUERY_TYPE, "open");
        this.rbBoth.setSelected("both".equals(v));
        this.rbOpenOnly.setSelected("open".equals(v));
        this.rbClosedOnly.setSelected("closed".equals(v));
    }

    @Override
    public boolean isValidChangesetQuery() {
        return true;
    }

    @Override
    public void displayMessageIfInvalid() {
    }
}

