/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.event;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.bugreport.BugReport;
import org.openstreetmap.josm.tools.bugreport.ReportedException;

public class SelectionEventManager
implements DataSelectionListener,
MainLayerManager.ActiveLayerChangeListener {
    private static final SelectionEventManager INSTANCE = new SelectionEventManager();
    private final CopyOnWriteArrayList<ListenerInfo> inEDTListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerInfo> immediatelyListeners = new CopyOnWriteArrayList();

    public static SelectionEventManager getInstance() {
        return INSTANCE;
    }

    protected SelectionEventManager() {
        MainLayerManager layerManager = MainApplication.getLayerManager();
        layerManager.addAndFireActiveLayerChangeListener(this);
    }

    public void addSelectionListener(DataSelectionListener listener) {
        this.immediatelyListeners.addIfAbsent(new DataListenerInfo(listener));
    }

    public void addSelectionListenerForEdt(DataSelectionListener listener) {
        this.inEDTListeners.addIfAbsent(new DataListenerInfo(listener));
    }

    public void removeSelectionListener(DataSelectionListener listener) {
        this.remove(new DataListenerInfo(listener));
    }

    private void remove(ListenerInfo searchListener) {
        this.inEDTListeners.remove(searchListener);
        this.immediatelyListeners.remove(searchListener);
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        DataSet newDataSet;
        DataSet oldDataSet = e.getPreviousDataSet();
        if (oldDataSet != null) {
            this.selectionChanged(new DataSelectionListener.SelectionReplaceEvent(oldDataSet, new HashSet<OsmPrimitive>(oldDataSet.getAllSelected()), Stream.empty()));
            oldDataSet.removeSelectionListener(this);
        }
        if ((newDataSet = e.getSource().getActiveDataSet()) != null) {
            newDataSet.addSelectionListener(this);
            this.selectionChanged(new DataSelectionListener.SelectionReplaceEvent(newDataSet, Collections.emptySet(), newDataSet.getAllSelected().stream()));
        }
    }

    @Override
    public void selectionChanged(DataSelectionListener.SelectionChangeEvent event) {
        SelectionEventManager.fireEvent(this.immediatelyListeners, event);
        try {
            GuiHelper.runInEDTAndWaitWithException(() -> SelectionEventManager.fireEvent(this.inEDTListeners, event));
        }
        catch (ReportedException e) {
            throw BugReport.intercept(e).put("event", event).put("inEDTListeners", this.inEDTListeners);
        }
    }

    private static void fireEvent(List<ListenerInfo> listeners, DataSelectionListener.SelectionChangeEvent event) {
        for (ListenerInfo listener : listeners) {
            try {
                listener.fire(event);
            }
            catch (DataIntegrityProblemException e) {
                throw BugReport.intercept(e).put("event", event).put("listeners", listeners);
            }
        }
    }

    public void resetState() {
        this.inEDTListeners.clear();
        this.immediatelyListeners.clear();
        MainApplication.getLayerManager().addAndFireActiveLayerChangeListener(this);
    }

    private static class DataListenerInfo
    implements ListenerInfo {
        private final DataSelectionListener listener;

        DataListenerInfo(DataSelectionListener listener) {
            this.listener = listener;
        }

        @Override
        public void fire(DataSelectionListener.SelectionChangeEvent event) {
            this.listener.selectionChanged(event);
        }

        public int hashCode() {
            return Objects.hash(this.listener);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataListenerInfo that = (DataListenerInfo)o;
            return Objects.equals(this.listener, that.listener);
        }

        public String toString() {
            return "DataListenerInfo [listener=" + this.listener + ']';
        }
    }

    private static interface ListenerInfo {
        public void fire(DataSelectionListener.SelectionChangeEvent var1);
    }
}

