/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.vcardtemp.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.vcardtemp.packet.VCard;

public class VCardProvider
extends IQProvider<VCard> {
    private static final String[] ADR = new String[]{"POSTAL", "PARCEL", "DOM", "INTL", "PREF", "POBOX", "EXTADR", "STREET", "LOCALITY", "REGION", "PCODE", "CTRY", "FF"};
    private static final String[] TEL = new String[]{"VOICE", "FAX", "PAGER", "MSG", "CELL", "VIDEO", "BBS", "MODEM", "ISDN", "PCS", "PREF"};

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public VCard parse(XmlPullParser parser2, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException {
        VCard vCard = new VCard();
        String name = null;
        while (true) {
            XmlPullParser.Event eventType = parser2.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    switch (name = parser2.getName()) {
                        case "N": {
                            VCardProvider.parseName(parser2, vCard);
                            break block0;
                        }
                        case "ORG": {
                            VCardProvider.parseOrg(parser2, vCard);
                            break block0;
                        }
                        case "TEL": {
                            VCardProvider.parseTel(parser2, vCard);
                            break block0;
                        }
                        case "ADR": {
                            VCardProvider.parseAddress(parser2, vCard);
                            break block0;
                        }
                        case "EMAIL": {
                            VCardProvider.parseEmail(parser2, vCard);
                            break block0;
                        }
                        case "NICKNAME": {
                            vCard.setNickName(parser2.nextText());
                            break block0;
                        }
                        case "JABBERID": {
                            vCard.setJabberId(parser2.nextText());
                            break block0;
                        }
                        case "PHOTO": {
                            VCardProvider.parsePhoto(parser2, vCard);
                            break block0;
                        }
                    }
                    break;
                }
                case TEXT_CHARACTERS: {
                    if (initialDepth + 1 != parser2.getDepth()) break;
                    String text = parser2.getText();
                    vCard.setField(name, text);
                    break;
                }
                case END_ELEMENT: {
                    if (parser2.getDepth() != initialDepth) break;
                    return vCard;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseAddress(XmlPullParser parser2, VCard vCard) throws XmlPullParserException, IOException {
        int initialDepth = parser2.getDepth();
        boolean isWork = true;
        while (true) {
            XmlPullParser.Event eventType = parser2.next();
            switch (eventType) {
                case START_ELEMENT: {
                    String name = parser2.getName();
                    if ("HOME".equals(name)) {
                        isWork = false;
                        break;
                    }
                    for (String adr : ADR) {
                        if (!adr.equals(name)) continue;
                        if (isWork) {
                            vCard.setAddressFieldWork(name, parser2.nextText());
                            continue;
                        }
                        vCard.setAddressFieldHome(name, parser2.nextText());
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser2.getDepth() != initialDepth) break;
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseTel(XmlPullParser parser2, VCard vCard) throws XmlPullParserException, IOException {
        int initialDepth = parser2.getDepth();
        boolean isWork = true;
        String telLabel = null;
        while (true) {
            XmlPullParser.Event eventType = parser2.next();
            switch (eventType) {
                case START_ELEMENT: {
                    String name = parser2.getName();
                    if ("HOME".equals(name)) {
                        isWork = false;
                        break;
                    }
                    if ("NUMBER".equals(name)) {
                        if (StringUtils.isNullOrEmpty(telLabel)) {
                            telLabel = "VOICE";
                        }
                        if (isWork) {
                            vCard.setPhoneWork(telLabel, parser2.nextText());
                            break;
                        }
                        vCard.setPhoneHome(telLabel, parser2.nextText());
                        break;
                    }
                    for (String tel : TEL) {
                        if (!tel.equals(name)) continue;
                        telLabel = name;
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser2.getDepth() != initialDepth) break;
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseOrg(XmlPullParser parser2, VCard vCard) throws XmlPullParserException, IOException {
        int initialDepth = parser2.getDepth();
        while (true) {
            XmlPullParser.Event eventType = parser2.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser2.getName()) {
                        case "ORGNAME": {
                            vCard.setOrganization(parser2.nextText());
                            break block0;
                        }
                        case "ORGUNIT": {
                            vCard.setOrganizationUnit(parser2.nextText());
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser2.getDepth() != initialDepth) break;
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseEmail(XmlPullParser parser2, VCard vCard) throws XmlPullParserException, IOException {
        int initialDepth = parser2.getDepth();
        boolean isWork = false;
        while (true) {
            XmlPullParser.Event eventType = parser2.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser2.getName()) {
                        case "WORK": {
                            isWork = true;
                            break block0;
                        }
                        case "USERID": {
                            if (isWork) {
                                vCard.setEmailWork(parser2.nextText());
                                break block0;
                            }
                            vCard.setEmailHome(parser2.nextText());
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser2.getDepth() != initialDepth) break;
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parseName(XmlPullParser parser2, VCard vCard) throws XmlPullParserException, IOException {
        int initialDepth = parser2.getDepth();
        while (true) {
            XmlPullParser.Event eventType = parser2.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser2.getName()) {
                        case "FAMILY": {
                            vCard.setLastName(parser2.nextText());
                            break block0;
                        }
                        case "GIVEN": {
                            vCard.setFirstName(parser2.nextText());
                            break block0;
                        }
                        case "MIDDLE": {
                            vCard.setMiddleName(parser2.nextText());
                            break block0;
                        }
                        case "PREFIX": {
                            vCard.setPrefix(parser2.nextText());
                            break block0;
                        }
                        case "SUFFIX": {
                            vCard.setSuffix(parser2.nextText());
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser2.getDepth() != initialDepth) break;
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parsePhoto(XmlPullParser parser2, VCard vCard) throws XmlPullParserException, IOException {
        int initialDepth = parser2.getDepth();
        String binval = null;
        String mimetype = null;
        block12: while (true) {
            XmlPullParser.Event eventType = parser2.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser2.getName()) {
                        case "BINVAL": {
                            binval = parser2.nextText();
                            break block0;
                        }
                        case "TYPE": {
                            mimetype = parser2.nextText();
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser2.getDepth() == initialDepth) break block12;
                }
            }
        }
        if (binval != null && mimetype != null) {
            vCard.setAvatar(binval, mimetype);
            return;
        }
    }
}

