/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.jetty.rewrite.handler.PatternRule;
import org.eclipse.jetty.util.annotation.Name;

public class CookiePatternRule
extends PatternRule {
    private String _name;
    private String _value;

    public CookiePatternRule() {
        this(null, null, null);
    }

    public CookiePatternRule(@Name(value="pattern") String pattern, @Name(value="name") String name, @Name(value="value") String value2) {
        super(pattern);
        this._handling = false;
        this._terminating = false;
        this.setName(name);
        this.setValue(value2);
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setValue(String value2) {
        this._value = value2;
    }

    @Override
    public String apply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!this._name.equals(cookie.getName()) || !this._value.equals(cookie.getValue())) continue;
                return target;
            }
        }
        response.addCookie(new Cookie(this._name, this._value));
        return target;
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this._name + "," + this._value + "]";
    }
}

