/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.SipStackImpl;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class CallAnalyzer {
    private static StackLogger logger = CommonLogger.getLogger(CallAnalyzer.class);
    private Map<Thread, HashMap<MetricReference, Object>> threadMap = new WeakHashMap<Thread, HashMap<MetricReference, Object>>();
    private MetricReferenceMap metricStatisticsMap = new MetricReferenceMap();
    private Timer timer = new Timer();
    private SipStackImpl stack;
    static int count = 0;

    public CallAnalyzer(SipStackImpl stack) {
        this.stack = stack;
    }

    public void configure(MetricReference ref, MetricAnalysisConfiguration config) {
        this.metricStatisticsMap.get((Object)ref).config = config;
        if (!this.isAnalysisStarted(ref)) {
            this.startAnalysis(ref);
        }
    }

    public boolean isAnalysisStarted(MetricReference ref) {
        return this.metricStatisticsMap.get((Object)ref).task != null;
    }

    public TImeMetricInfo getMetricStats(MetricReference ref) {
        return this.metricStatisticsMap.get(ref);
    }

    public void resetStats(MetricReference metricReference) {
        TImeMetricInfo info = this.metricStatisticsMap.get(metricReference);
        info.totalTime = new Long(0L);
        info.numberOfEvents = new Long(0L);
        info.averageTime = new Long(1L);
        info.lastLoggedEventTime = new Long(0L);
    }

    public CallAnalyzer() {
    }

    public void stopAnalysis(MetricReference metricReference) {
        TImeMetricInfo statInfo = this.metricStatisticsMap.get(metricReference);
        if (statInfo.task != null) {
            statInfo.task.cancel();
            statInfo.task = null;
        }
    }

    public void startAnalysis(final MetricReference metricReference) {
        this.stopAnalysis(metricReference);
        this.resetStats(metricReference);
        final TImeMetricInfo statInfo = this.metricStatisticsMap.get(metricReference);
        statInfo.task = new TimerTask(){

            @Override
            public void run() {
                block5: {
                    try {
                        Long lastDump = statInfo.lastLoggedEventTime;
                        if (System.currentTimeMillis() - lastDump <= statInfo.config.minimumDumpInterval) break block5;
                        for (Map.Entry info : CallAnalyzer.this.threadMap.entrySet()) {
                            Long entryTime = (Long)((HashMap)info.getValue()).get(metricReference);
                            if (entryTime.equals(Long.MIN_VALUE)) continue;
                            Long delta = System.currentTimeMillis() - entryTime;
                            if (logger == null || delta <= statInfo.config.stuckTimeBeforeDump) continue;
                            logger.logWarning("Offending thread:\n" + CallAnalyzer.this.getCurrentStack((Thread)info.getKey()));
                            StringBuilder sb = new StringBuilder();
                            Thread[] threads = new Thread[5000];
                            int count2 = Thread.enumerate(threads);
                            for (int q = 0; q < count2; ++q) {
                                long threadStuck = 0L;
                                HashMap subInfo = (HashMap)CallAnalyzer.this.threadMap.get(threads[q]);
                                if (subInfo == null) continue;
                                Long stamp = (Long)((HashMap)CallAnalyzer.this.threadMap.get(threads[q])).get(metricReference);
                                if (stamp != null) {
                                    threadStuck = System.currentTimeMillis() - stamp;
                                }
                                if (stamp == Long.MIN_VALUE) continue;
                                sb.append("->Stuck time:" + threadStuck + " " + CallAnalyzer.this.getCurrentStack(threads[q]));
                            }
                            logger.logWarning(sb.toString());
                            threads = null;
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        this.timer.scheduleAtFixedRate(statInfo.task, statInfo.config.checkingInterval, (long)statInfo.config.checkingInterval);
    }

    public void stop() {
        this.timer.cancel();
        this.timer = null;
    }

    public Long getTime(Thread threadId, MetricReference metricReference) {
        HashMap<MetricReference, Object> attribs = this.getAttributes(threadId);
        return (Long)attribs.get(metricReference);
    }

    public void setObject(Thread threadId, MetricReference objectName, Object object) {
        this.getAttributes(threadId).put(objectName, object);
    }

    public Object getObject(Thread threadId, String objectName) {
        return this.getAttributes(threadId).get(objectName);
    }

    public synchronized HashMap<MetricReference, Object> getAttributes(Thread threadId) {
        HashMap<MetricReference, Object> threadLocal = this.threadMap.get(threadId);
        if (threadLocal == null) {
            threadLocal = new HashMap();
            this.threadMap.put(threadId, threadLocal);
        }
        return threadLocal;
    }

    public void enter(MetricReference metricReference) {
        Thread threadId = Thread.currentThread();
        this.enter(threadId, metricReference);
    }

    public void leave(MetricReference metricReference) {
        Thread threadId = Thread.currentThread();
        this.leave(threadId, metricReference);
    }

    public void enter(Thread threadId, MetricReference metricReference) {
        HashMap<MetricReference, Object> attribs = this.getAttributes(threadId);
        attribs.put(metricReference, System.currentTimeMillis());
    }

    public void leave(Thread threadId, MetricReference metricReference) {
        TImeMetricInfo info = this.metricStatisticsMap.get(metricReference);
        HashMap<MetricReference, Object> attribs = this.getAttributes(threadId);
        long delta = System.currentTimeMillis() - (Long)attribs.get(metricReference);
        TImeMetricInfo tImeMetricInfo = info;
        tImeMetricInfo.totalTime = tImeMetricInfo.totalTime + delta;
        tImeMetricInfo = info;
        Long l = tImeMetricInfo.numberOfEvents;
        Long l2 = tImeMetricInfo.numberOfEvents = Long.valueOf(tImeMetricInfo.numberOfEvents + 1L);
        info.averageTime = info.totalTime / info.numberOfEvents;
        attribs.put(metricReference, Long.MIN_VALUE);
    }

    public String getCurrentStack(Thread thread2) {
        StackTraceElement[] ste;
        StringBuilder sb = new StringBuilder();
        sb.append("\n" + thread2.getName() + " " + thread2.getId() + " " + thread2.getState().toString() + "\n");
        for (StackTraceElement el : ste = thread2.getStackTrace()) {
            sb.append(" " + el.toString() + "\n");
        }
        return sb.toString();
    }

    public String getThreadDump() {
        StringBuilder sb = new StringBuilder();
        Thread[] threads = new Thread[5000];
        int count2 = Thread.enumerate(threads);
        for (int q = 0; q < count2; ++q) {
            sb.append(this.getCurrentStack(threads[q]));
        }
        return sb.toString();
    }

    public int getNumberOfThreads() {
        return this.threadMap.size();
    }

    public static void main(String[] arg) throws InterruptedException {
        ExecutorService ex = Executors.newFixedThreadPool(1000);
        final CallAnalyzer tp = new CallAnalyzer();
        final MetricReference sec = new MetricReference("sec");
        MetricReference se1c = new MetricReference("se111c");
        tp.configure(sec, new MetricAnalysisConfiguration(500, 500, 500));
        tp.startAnalysis(sec);
        tp.startAnalysis(se1c);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                tp.enter(sec);
                try {
                    if (++count % 10000 == 0) {
                        System.out.println("Avg " + tp.getMetricStats((MetricReference)sec).averageTime);
                        Thread.sleep(1000L);
                    }
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                tp.leave(sec);
            }
        };
        for (int q = 0; q < 2000000; ++q) {
            ex.execute(r);
        }
        System.out.println("size:" + tp.threadMap.size() + " " + tp.metricStatisticsMap.size());
        ex.shutdown();
        ex.awaitTermination(200L, TimeUnit.SECONDS);
        ex.shutdownNow();
        System.gc();
        System.out.println("size:" + tp.threadMap.size() + " " + tp.metricStatisticsMap.size());
        System.gc();
        Thread.sleep(5000L);
        System.gc();
        System.out.println("size:" + tp.threadMap.size() + " " + tp.metricStatisticsMap.size());
        System.gc();
        se1c = null;
        System.gc();
        Thread.sleep(5000L);
        System.out.println("size:" + tp.threadMap.size() + " " + tp.metricStatisticsMap.size());
        System.gc();
        System.gc();
        Thread.sleep(5000L);
        System.out.println("size:" + tp.threadMap.size() + " " + tp.metricStatisticsMap.size());
        System.gc();
        Thread.sleep(5000L);
        System.gc();
        System.out.println("size:" + tp.threadMap.size() + " " + tp.metricStatisticsMap.size());
        System.gc();
        System.gc();
        Thread.sleep(5000L);
        System.out.println("size:" + tp.threadMap.size() + " " + tp.metricStatisticsMap.size());
        System.gc();
        System.gc();
        Thread.sleep(5000L);
        System.out.println("size:" + tp.threadMap.size() + " " + tp.metricStatisticsMap.size());
        System.gc();
        if (tp.threadMap.size() > 0) {
            throw new RuntimeException("Should be zero by this point. Leak.");
        }
    }

    public static class ThreadInfo {
        public LinkedList<StackTrace> stackTraces = new LinkedList();
        public Object data;
    }

    public static class StackTrace {
        public int delta;
        public String trace;

        public StackTrace(int delta, String trace) {
            this.delta = delta;
            this.trace = trace;
        }
    }

    public static class MetricReferenceMap
    extends WeakHashMap<MetricReference, TImeMetricInfo> {
        private static final long serialVersionUID = 393231609328924828L;

        @Override
        public TImeMetricInfo get(Object key) {
            if (super.get(key) == null) {
                super.put((MetricReference)key, new TImeMetricInfo());
            }
            return (TImeMetricInfo)super.get(key);
        }
    }

    public static class MetricReference {
        public String name;

        public MetricReference(String name) {
            this.name = name;
        }

        public boolean equals(Object other) {
            if (other instanceof MetricReference) {
                MetricReference stat = (MetricReference)other;
                return stat.name.equals(this.name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static class MetricAnalysisConfiguration {
        protected Long checkingInterval;
        protected Long minimumDumpInterval;
        protected Long stuckTimeBeforeDump;

        public MetricAnalysisConfiguration(Long checkingInterval, Long minDumpInterval, Long stuckTimerBeforeDump) {
            this.checkingInterval = checkingInterval;
            this.minimumDumpInterval = minDumpInterval;
            this.stuckTimeBeforeDump = stuckTimerBeforeDump;
        }

        public MetricAnalysisConfiguration(int checkingInterval, int minDumpInterval, int stuckTimerBeforeDump) {
            this.checkingInterval = new Long(checkingInterval);
            this.minimumDumpInterval = new Long(minDumpInterval);
            this.stuckTimeBeforeDump = new Long(stuckTimerBeforeDump);
        }
    }

    public static class TImeMetricInfo {
        public Long totalTime = new Long(0L);
        public Long numberOfEvents = new Long(0L);
        public Long averageTime = new Long(1L);
        public Long lastLoggedEventTime = new Long(0L);
        protected TimerTask task;
        protected MetricAnalysisConfiguration config = new MetricAnalysisConfiguration(5000, 5000, 5000);
    }
}

