/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.fsm;

import org.jivesoftware.smack.fsm.State;
import org.jivesoftware.smack.fsm.StateDescriptor;
import org.jivesoftware.smack.fsm.StateDescriptorGraph;
import org.jivesoftware.smack.fsm.StateTransitionResult;

public class ConnectionStateEvent {
    private final StateDescriptor currentStateDescriptor;
    private final StateDescriptor successorStateDescriptor;
    private final long timestamp;

    public ConnectionStateEvent(StateDescriptor currentStateDescriptor) {
        this(currentStateDescriptor, null);
    }

    public ConnectionStateEvent(StateDescriptor currentStateDescriptor, StateDescriptor successorStateDescriptor) {
        this.currentStateDescriptor = currentStateDescriptor;
        this.successorStateDescriptor = successorStateDescriptor;
        this.timestamp = System.currentTimeMillis();
    }

    public StateDescriptor getStateDescriptor() {
        return this.currentStateDescriptor;
    }

    public String toString() {
        if (this.successorStateDescriptor == null) {
            return this.getClass().getSimpleName() + ": " + this.currentStateDescriptor.getStateName();
        }
        return this.currentStateDescriptor.getStateName() + ' ' + this.getClass().getSimpleName() + ' ' + this.successorStateDescriptor.getStateName();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public static abstract class DetailedTransitionIntoInformation
    extends ConnectionStateEvent {
        protected DetailedTransitionIntoInformation(State state) {
            super(state.getStateDescriptor());
        }
    }

    public static class SuccessfullyTransitionedInto
    extends ConnectionStateEvent {
        private final StateTransitionResult.Success transitionSuccessResult;

        public SuccessfullyTransitionedInto(State state, StateTransitionResult.Success transitionSuccessResult) {
            super(state.getStateDescriptor());
            this.transitionSuccessResult = transitionSuccessResult;
        }

        @Override
        public String toString() {
            return super.toString() + ": " + this.transitionSuccessResult;
        }
    }

    public static class TransitionIgnoredDueCycle
    extends ConnectionStateEvent {
        public TransitionIgnoredDueCycle(StateDescriptorGraph.GraphVertex<State> currentStateVertex, StateDescriptorGraph.GraphVertex<State> successorStateVertexCausingCycle) {
            super(currentStateVertex.getElement().getStateDescriptor(), successorStateVertexCausingCycle.getElement().getStateDescriptor());
        }
    }

    public static class TransitionFailed
    extends ConnectionStateEvent {
        private final StateTransitionResult.Failure transitionFailedReason;

        public TransitionFailed(State currentState, State failedSuccessorState, StateTransitionResult.Failure transitionFailedReason) {
            super(currentState.getStateDescriptor(), failedSuccessorState.getStateDescriptor());
            this.transitionFailedReason = transitionFailedReason;
        }

        @Override
        public String toString() {
            return super.toString() + ": " + this.transitionFailedReason;
        }
    }

    public static class AboutToTransitionInto
    extends ConnectionStateEvent {
        public AboutToTransitionInto(State currentState, State successorState) {
            super(currentState.getStateDescriptor(), successorState.getStateDescriptor());
        }
    }

    public static class TransitionNotPossible
    extends ConnectionStateEvent {
        private final StateTransitionResult.TransitionImpossible transitionImpossibleReason;

        public TransitionNotPossible(State currentState, State successorState, StateTransitionResult.TransitionImpossible reason) {
            super(currentState.getStateDescriptor(), successorState.getStateDescriptor());
            this.transitionImpossibleReason = reason;
        }

        @Override
        public String toString() {
            return super.toString() + ": " + this.transitionImpossibleReason;
        }
    }

    public static class FinalStateReached
    extends ConnectionStateEvent {
        public FinalStateReached(State state) {
            super(state.getStateDescriptor());
        }
    }

    public static class StateRevertBackwardsWalk
    extends ConnectionStateEvent {
        public StateRevertBackwardsWalk(State state) {
            super(state.getStateDescriptor());
        }
    }
}

