/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TextAction;

public class Stylepad
extends Notepad {
    private static ResourceBundle resources;
    private FileDialog fileDialog;
    private static final String[] MENUBAR_KEYS;
    private static final String[] FONT_KEYS;
    private static final String[] TOOLBAR_KEYS;

    public static void main(String[] args) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JFrame frame = new JFrame();
                    frame.setTitle(resources.getString("Title"));
                    frame.setBackground(Color.lightGray);
                    frame.getContentPane().setLayout(new BorderLayout());
                    Stylepad stylepad = new Stylepad();
                    frame.getContentPane().add("Center", stylepad);
                    frame.setJMenuBar(stylepad.createMenubar());
                    frame.addWindowListener(new Notepad.AppCloser());
                    frame.pack();
                    frame.setSize(600, 480);
                    frame.setVisible(true);
                }
            });
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Stylepad.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(Stylepad.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public Action[] getActions() {
        Action[] defaultActions = new Action[]{new NewAction(), new OpenAction(), new SaveAction(), new StyledEditorKit.FontFamilyAction("font-family-SansSerif", "SansSerif")};
        Action[] a = TextAction.augmentList(super.getActions(), defaultActions);
        return a;
    }

    @Override
    protected String getResourceString(String nm) {
        String str;
        try {
            str = resources.getString(nm);
        }
        catch (MissingResourceException mre) {
            str = super.getResourceString(nm);
        }
        return str;
    }

    @Override
    protected JTextComponent createEditor() {
        StyleContext sc = new StyleContext();
        DefaultStyledDocument doc = new DefaultStyledDocument(sc);
        this.initDocument(doc, sc);
        JTextPane p = new JTextPane(doc);
        p.setDragEnabled(true);
        return p;
    }

    @Override
    protected JMenu createMenu(String key) {
        if (key.equals("color")) {
            return this.createColorMenu();
        }
        return super.createMenu(key);
    }

    @Override
    protected String[] getItemKeys(String key) {
        switch (key) {
            case "font": {
                return FONT_KEYS;
            }
        }
        return super.getItemKeys(key);
    }

    @Override
    protected String[] getMenuBarKeys() {
        return MENUBAR_KEYS;
    }

    @Override
    protected String[] getToolBarKeys() {
        return TOOLBAR_KEYS;
    }

    JMenu createColorMenu() {
        JMenu menu = new JMenu(this.getResourceString("colorLabel"));
        JMenuItem mi = new JMenuItem(resources.getString("Red"));
        mi.setHorizontalTextPosition(4);
        mi.setIcon(new ColoredSquare(Color.red));
        StyledEditorKit.ForegroundAction a = new StyledEditorKit.ForegroundAction("set-foreground-red", Color.red);
        mi.addActionListener(a);
        menu.add(mi);
        mi = new JMenuItem(resources.getString("Green"));
        mi.setHorizontalTextPosition(4);
        mi.setIcon(new ColoredSquare(Color.green));
        a = new StyledEditorKit.ForegroundAction("set-foreground-green", Color.green);
        mi.addActionListener(a);
        menu.add(mi);
        mi = new JMenuItem(resources.getString("Blue"));
        mi.setHorizontalTextPosition(4);
        mi.setIcon(new ColoredSquare(Color.blue));
        a = new StyledEditorKit.ForegroundAction("set-foreground-blue", Color.blue);
        mi.addActionListener(a);
        menu.add(mi);
        return menu;
    }

    void initDocument(DefaultStyledDocument doc, StyleContext sc) {
        Wonderland w = new Wonderland(doc, sc);
        w.loadDocument();
    }

    JComboBox createFamilyChoices() {
        String[] fontNames;
        JComboBox<String> b = new JComboBox<String>();
        for (String fontName : fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            b.addItem(fontName);
        }
        return b;
    }

    static {
        MENUBAR_KEYS = new String[]{"file", "edit", "color", "font", "debug"};
        FONT_KEYS = new String[]{"family1", "family2", "family3", "family4", "-", "size1", "size2", "size3", "size4", "size5", "-", "bold", "italic", "underline"};
        TOOLBAR_KEYS = new String[]{"new", "open", "save", "-", "cut", "copy", "paste", "-", "bold", "italic", "underline", "-", "left", "center", "right"};
        try {
            properties.load(Stylepad.class.getResourceAsStream("resources/StylepadSystem.properties"));
            resources = ResourceBundle.getBundle("resources.Stylepad");
        }
        catch (IOException | MissingResourceException mre) {
            System.err.println("Stylepad.properties or StylepadSystem.properties not found");
            System.exit(0);
        }
    }

    class ColoredSquare
    implements Icon {
        Color color;

        public ColoredSquare(Color c) {
            this.color = c;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color oldColor = g.getColor();
            g.setColor(this.color);
            g.fill3DRect(x, y, this.getIconWidth(), this.getIconHeight(), true);
            g.setColor(oldColor);
        }

        @Override
        public int getIconWidth() {
            return 12;
        }

        @Override
        public int getIconHeight() {
            return 12;
        }
    }

    class NewAction
    extends AbstractAction {
        NewAction() {
            super("new");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Stylepad.this.getEditor().getDocument() != null) {
                Stylepad.this.getEditor().getDocument().removeUndoableEditListener(Stylepad.this.undoHandler);
            }
            Stylepad.this.getEditor().setDocument(new DefaultStyledDocument());
            Stylepad.this.getEditor().getDocument().addUndoableEditListener(Stylepad.this.undoHandler);
            Stylepad.this.resetUndoManager();
            Stylepad.this.getFrame().setTitle(resources.getString("Title"));
            Stylepad.this.validate();
        }
    }

    class SaveAction
    extends AbstractAction {
        SaveAction() {
            super("save");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Frame frame = Stylepad.this.getFrame();
            if (Stylepad.this.fileDialog == null) {
                Stylepad.this.fileDialog = new FileDialog(frame);
            }
            Stylepad.this.fileDialog.setMode(1);
            Stylepad.this.fileDialog.setVisible(true);
            String file = Stylepad.this.fileDialog.getFile();
            if (file == null) {
                return;
            }
            String directory = Stylepad.this.fileDialog.getDirectory();
            File f = new File(directory, file);
            try {
                FileOutputStream fstrm = new FileOutputStream(f);
                ObjectOutputStream ostrm = new ObjectOutputStream(fstrm);
                ostrm.writeObject(Stylepad.this.getEditor().getDocument());
                ostrm.flush();
                frame.setTitle(f.getName());
            }
            catch (IOException io) {
                System.err.println("IOException: " + io.getMessage());
            }
        }
    }

    class OpenAction
    extends AbstractAction {
        OpenAction() {
            super("open");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Frame frame = Stylepad.this.getFrame();
            if (Stylepad.this.fileDialog == null) {
                Stylepad.this.fileDialog = new FileDialog(frame);
            }
            Stylepad.this.fileDialog.setMode(0);
            Stylepad.this.fileDialog.setVisible(true);
            String file = Stylepad.this.fileDialog.getFile();
            if (file == null) {
                return;
            }
            String directory = Stylepad.this.fileDialog.getDirectory();
            File f = new File(directory, file);
            if (f.exists()) {
                try {
                    FileInputStream fin = new FileInputStream(f);
                    ObjectInputStream istrm = new ObjectInputStream(fin);
                    Document doc = (Document)istrm.readObject();
                    if (Stylepad.this.getEditor().getDocument() != null) {
                        Stylepad.this.getEditor().getDocument().removeUndoableEditListener(Stylepad.this.undoHandler);
                    }
                    Stylepad.this.getEditor().setDocument(doc);
                    doc.addUndoableEditListener(Stylepad.this.undoHandler);
                    Stylepad.this.resetUndoManager();
                    frame.setTitle(file);
                    Stylepad.this.validate();
                }
                catch (IOException io) {
                    System.err.println("IOException: " + io.getMessage());
                }
                catch (ClassNotFoundException cnf) {
                    System.err.println("Class not found: " + cnf.getMessage());
                }
            } else {
                System.err.println("No such file: " + String.valueOf(f));
            }
        }
    }
}

