/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.text.resources.cldr.sk;

import java.util.ListResourceBundle;

public class FormatData_sk extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "MonthNames",
                new String[] {
                    "janu\u00e1ra",
                    "febru\u00e1ra",
                    "marca",
                    "apr\u00edla",
                    "m\u00e1ja",
                    "j\u00fana",
                    "j\u00fala",
                    "augusta",
                    "septembra",
                    "okt\u00f3bra",
                    "novembra",
                    "decembra",
                    "",
                }
            },
            { "standalone.MonthNames",
                new String[] {
                    "janu\u00e1r",
                    "febru\u00e1r",
                    "marec",
                    "apr\u00edl",
                    "m\u00e1j",
                    "j\u00fan",
                    "j\u00fal",
                    "august",
                    "september",
                    "okt\u00f3ber",
                    "november",
                    "december",
                    "",
                }
            },
            { "MonthAbbreviations",
                new String[] {
                    "jan",
                    "feb",
                    "mar",
                    "apr",
                    "m\u00e1j",
                    "j\u00fan",
                    "j\u00fal",
                    "aug",
                    "sep",
                    "okt",
                    "nov",
                    "dec",
                    "",
                }
            },
            { "MonthNarrows",
                new String[] {
                    "j",
                    "f",
                    "m",
                    "a",
                    "m",
                    "j",
                    "j",
                    "a",
                    "s",
                    "o",
                    "n",
                    "d",
                    "",
                }
            },
            { "DayNames",
                new String[] {
                    "nede\u013ea",
                    "pondelok",
                    "utorok",
                    "streda",
                    "\u0161tvrtok",
                    "piatok",
                    "sobota",
                }
            },
            { "standalone.DayNames",
                new String[] {
                    "nede\u013ea",
                    "pondelok",
                    "utorok",
                    "streda",
                    "\u0161tvrtok",
                    "piatok",
                    "sobota",
                }
            },
            { "DayAbbreviations",
                new String[] {
                    "ne",
                    "po",
                    "ut",
                    "st",
                    "\u0161t",
                    "pi",
                    "so",
                }
            },
            { "standalone.DayAbbreviations",
                new String[] {
                    "ne",
                    "po",
                    "ut",
                    "st",
                    "\u0161t",
                    "pi",
                    "so",
                }
            },
            { "DayNarrows",
                new String[] {
                    "N",
                    "P",
                    "U",
                    "S",
                    "\u0160",
                    "P",
                    "S",
                }
            },
            { "standalone.DayNarrows",
                new String[] {
                    "N",
                    "P",
                    "U",
                    "S",
                    "\u0160",
                    "P",
                    "S",
                }
            },
            { "QuarterNames",
                new String[] {
                    "1. \u0161tvr\u0165rok",
                    "2. \u0161tvr\u0165rok",
                    "3. \u0161tvr\u0165rok",
                    "4. \u0161tvr\u0165rok",
                }
            },
            { "standalone.QuarterNames",
                new String[] {
                    "1. \u0161tvr\u0165rok",
                    "2. \u0161tvr\u0165rok",
                    "3. \u0161tvr\u0165rok",
                    "4. \u0161tvr\u0165rok",
                }
            },
            { "QuarterAbbreviations",
                new String[] {
                    "Q1",
                    "Q2",
                    "Q3",
                    "Q4",
                }
            },
            { "standalone.QuarterAbbreviations",
                new String[] {
                    "1Q",
                    "2Q",
                    "3Q",
                    "4Q",
                }
            },
            { "QuarterNarrows",
                new String[] {
                    "1",
                    "2",
                    "3",
                    "4",
                }
            },
            { "AmPmMarkers",
                new String[] {
                    "dopoludnia",
                    "popoludn\u00ed",
                }
            },
            { "Eras",
                new String[] {
                    "pred n.l.",
                    "n.l.",
                }
            },
            { "field.era", "\u00c9ra" },
            { "field.year", "Rok" },
            { "field.month", "Mesiac" },
            { "field.week", "T\u00fd\u017ede\u0148" },
            { "field.weekday", "De\u0148 v t\u00fd\u017edni" },
            { "field.dayperiod", "\u010cas\u0165 d\u0148a" },
            { "field.hour", "Hodina" },
            { "field.minute", "Min\u00fata" },
            { "field.second", "Sekunda" },
            { "field.zone", "P\u00e1smo" },
            { "TimePatterns",
                new String[] {
                    "H:mm:ss zzzz",
                    "H:mm:ss z",
                    "H:mm:ss",
                    "H:mm",
                }
            },
            { "DatePatterns",
                new String[] {
                    "EEEE, d. MMMM y",
                    "d. MMMM y",
                    "d.M.yyyy",
                    "d.M.yyyy",
                }
            },
            { "calendarname.gregorian", "Gregori\u00e1nsky kalend\u00e1r" },
            { "calendarname.gregory", "Gregori\u00e1nsky kalend\u00e1r" },
            { "calendarname.roc", "Kalend\u00e1r \u010c\u00ednskej republiky" },
            { "calendarname.islamic-civil", "Islamsk\u00fd ob\u010diansky kalend\u00e1r" },
            { "calendarname.islamicc", "Islamsk\u00fd ob\u010diansky kalend\u00e1r" },
            { "calendarname.japanese", "Japonsk\u00fd kalend\u00e1r" },
            { "calendarname.buddhist", "Buddhistick\u00fd kalend\u00e1r" },
            { "calendarname.islamic", "Islamsk\u00fd kalend\u00e1r" },
            { "DefaultNumberingSystem", "latn" },
            { "latn.NumberElements",
                new String[] {
                    ",",
                    "\u00a0",
                    ",",
                    "%",
                    "0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                }
            },
            { "NumberPatterns",
                new String[] {
                    "#,##0.###",
                    "#,##0.00\u00a0\u00a4",
                    "#,##0\u00a0%",
                }
            },
        };
        return data;
    }
}
