/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import sun.misc.Unsafe;

public class AtomicStampedReference<V> {
    private volatile Pair<V> pair;
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    private static final long pairOffset = AtomicStampedReference.objectFieldOffset(UNSAFE, "pair", AtomicStampedReference.class);

    public AtomicStampedReference(V v, int n) {
        this.pair = Pair.of(v, n);
    }

    public V getReference() {
        return (V)this.pair.reference;
    }

    public int getStamp() {
        return this.pair.stamp;
    }

    public V get(int[] nArray) {
        Pair<V> pair = this.pair;
        nArray[0] = pair.stamp;
        return (V)pair.reference;
    }

    public boolean weakCompareAndSet(V v, V v2, int n, int n2) {
        return this.compareAndSet(v, v2, n, n2);
    }

    public boolean compareAndSet(V v, V v2, int n, int n2) {
        Pair<V> pair = this.pair;
        return v == pair.reference && n == pair.stamp && (v2 == pair.reference && n2 == pair.stamp || this.casPair(pair, Pair.of(v2, n2)));
    }

    public void set(V v, int n) {
        Pair<V> pair = this.pair;
        if (v != pair.reference || n != pair.stamp) {
            this.pair = Pair.of(v, n);
        }
    }

    public boolean attemptStamp(V v, int n) {
        Pair<V> pair = this.pair;
        return v == pair.reference && (n == pair.stamp || this.casPair(pair, Pair.of(v, n)));
    }

    private boolean casPair(Pair<V> pair, Pair<V> pair2) {
        return UNSAFE.compareAndSwapObject(this, pairOffset, pair, pair2);
    }

    static long objectFieldOffset(Unsafe unsafe, String string, Class<?> clazz) {
        try {
            return unsafe.objectFieldOffset(clazz.getDeclaredField(string));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            NoSuchFieldError noSuchFieldError = new NoSuchFieldError(string);
            noSuchFieldError.initCause(noSuchFieldException);
            throw noSuchFieldError;
        }
    }

    private static class Pair<T> {
        final T reference;
        final int stamp;

        private Pair(T t, int n) {
            this.reference = t;
            this.stamp = n;
        }

        static <T> Pair<T> of(T t, int n) {
            return new Pair<T>(t, n);
        }
    }
}

