/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import sun.reflect.annotation.AnnotationSupport;
import sun.reflect.annotation.AnnotationType;

public interface AnnotatedElement {
    default public boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
        return this.getAnnotation(clazz) != null;
    }

    public <T extends Annotation> T getAnnotation(Class<T> var1);

    public Annotation[] getAnnotations();

    default public <T extends Annotation> T[] getAnnotationsByType(Class<T> clazz) {
        Class clazz2;
        Annotation[] annotationArray = this.getDeclaredAnnotationsByType(clazz);
        if (annotationArray.length == 0 && this instanceof Class && AnnotationType.getInstance(clazz).isInherited() && (clazz2 = ((Class)this).getSuperclass()) != null) {
            annotationArray = clazz2.getAnnotationsByType(clazz);
        }
        return annotationArray;
    }

    default public <T extends Annotation> T getDeclaredAnnotation(Class<T> clazz) {
        Objects.requireNonNull(clazz);
        for (Annotation annotation : this.getDeclaredAnnotations()) {
            if (!clazz.equals(annotation.annotationType())) continue;
            return (T)((Annotation)clazz.cast(annotation));
        }
        return null;
    }

    default public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> clazz) {
        Objects.requireNonNull(clazz);
        return AnnotationSupport.getDirectlyAndIndirectlyPresent((Map)Arrays.stream(this.getDeclaredAnnotations()).collect(Collectors.toMap(Annotation::annotationType, Function.identity(), (annotation, annotation2) -> annotation, LinkedHashMap::new)), clazz);
    }

    public Annotation[] getDeclaredAnnotations();
}

