/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import sun.reflect.misc.ReflectUtil;

final class MethodRef {
    private String signature;
    private SoftReference<Method> methodRef;
    private WeakReference<Class<?>> typeRef;

    MethodRef() {
    }

    void set(Method method) {
        if (method == null) {
            this.signature = null;
            this.methodRef = null;
            this.typeRef = null;
        } else {
            this.signature = method.toGenericString();
            this.methodRef = new SoftReference<Method>(method);
            this.typeRef = new WeakReference(method.getDeclaringClass());
        }
    }

    boolean isSet() {
        return this.methodRef != null;
    }

    Method get() {
        if (this.methodRef == null) {
            return null;
        }
        Method method = this.methodRef.get();
        if (method == null) {
            method = MethodRef.find((Class)this.typeRef.get(), this.signature);
            if (method == null) {
                this.signature = null;
                this.methodRef = null;
                this.typeRef = null;
                return null;
            }
            this.methodRef = new SoftReference<Method>(method);
        }
        return ReflectUtil.isPackageAccessible(method.getDeclaringClass()) ? method : null;
    }

    private static Method find(Class<?> clazz, String string) {
        if (clazz != null) {
            for (Method method : clazz.getMethods()) {
                if (!clazz.equals(method.getDeclaringClass()) || !method.toGenericString().equals(string)) continue;
                return method;
            }
        }
        return null;
    }
}

