/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DHPrivateKey;
import com.sun.crypto.provider.DHPublicKey;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

public final class DHKeyFactory
extends KeyFactorySpi {
    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof DHPublicKeySpec) {
                DHPublicKeySpec dHPublicKeySpec = (DHPublicKeySpec)keySpec;
                return new DHPublicKey(dHPublicKeySpec.getY(), dHPublicKeySpec.getP(), dHPublicKeySpec.getG());
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new DHPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Inappropriate key specification", invalidKeyException);
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof DHPrivateKeySpec) {
                DHPrivateKeySpec dHPrivateKeySpec = (DHPrivateKeySpec)keySpec;
                return new DHPrivateKey(dHPrivateKeySpec.getX(), dHPrivateKeySpec.getP(), dHPrivateKeySpec.getG());
            }
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                return new DHPrivateKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Inappropriate key specification", invalidKeyException);
        }
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
        if (key instanceof javax.crypto.interfaces.DHPublicKey) {
            if (clazz.isAssignableFrom(DHPublicKeySpec.class)) {
                javax.crypto.interfaces.DHPublicKey dHPublicKey = (javax.crypto.interfaces.DHPublicKey)key;
                DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
                return (T)((KeySpec)clazz.cast(new DHPublicKeySpec(dHPublicKey.getY(), dHParameterSpec.getP(), dHParameterSpec.getG())));
            }
            if (clazz.isAssignableFrom(X509EncodedKeySpec.class)) {
                return (T)((KeySpec)clazz.cast(new X509EncodedKeySpec(key.getEncoded())));
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        if (key instanceof javax.crypto.interfaces.DHPrivateKey) {
            if (clazz.isAssignableFrom(DHPrivateKeySpec.class)) {
                javax.crypto.interfaces.DHPrivateKey dHPrivateKey = (javax.crypto.interfaces.DHPrivateKey)key;
                DHParameterSpec dHParameterSpec = dHPrivateKey.getParams();
                return (T)((KeySpec)clazz.cast(new DHPrivateKeySpec(dHPrivateKey.getX(), dHParameterSpec.getP(), dHParameterSpec.getG())));
            }
            if (clazz.isAssignableFrom(PKCS8EncodedKeySpec.class)) {
                return (T)((KeySpec)clazz.cast(new PKCS8EncodedKeySpec(key.getEncoded())));
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        throw new InvalidKeySpecException("Inappropriate key type");
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            if (key instanceof javax.crypto.interfaces.DHPublicKey) {
                if (key instanceof DHPublicKey) {
                    return key;
                }
                DHPublicKeySpec dHPublicKeySpec = this.engineGetKeySpec(key, DHPublicKeySpec.class);
                return this.engineGeneratePublic(dHPublicKeySpec);
            }
            if (key instanceof javax.crypto.interfaces.DHPrivateKey) {
                if (key instanceof DHPrivateKey) {
                    return key;
                }
                DHPrivateKeySpec dHPrivateKeySpec = this.engineGetKeySpec(key, DHPrivateKeySpec.class);
                return this.engineGeneratePrivate(dHPrivateKeySpec);
            }
            throw new InvalidKeyException("Wrong algorithm type");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Cannot translate key", invalidKeySpecException);
        }
    }
}

