/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class RangeMenu
extends JComboBox
implements ActionListener {
    private static final int[][] UNICODE_RANGES = RangeMenu.getUnicodeRanges();
    private static final String[] UNICODE_RANGE_NAMES = RangeMenu.getUnicodeRangeNames();
    private boolean useCustomRange = false;
    private int[] customRange = new int[]{0, 127};
    private final JDialog customRangeDialog;
    private final JTextField customRangeStart = new JTextField("0000", 4);
    private final JTextField customRangeEnd = new JTextField("007F", 4);
    private final int CUSTOM_RANGE_INDEX = UNICODE_RANGE_NAMES.length - 1;
    private final Font2DTest parent;
    public static final int SURROGATES_AREA_INDEX = 91;

    public RangeMenu(Font2DTest font2DTest, JFrame jFrame) {
        this.parent = font2DTest;
        for (int i = 0; i < UNICODE_RANGE_NAMES.length; ++i) {
            this.addItem(UNICODE_RANGE_NAMES[i]);
        }
        this.setSelectedIndex(0);
        this.addActionListener(this);
        this.customRangeDialog = new JDialog(jFrame, "Custom Unicode Range", true);
        this.customRangeDialog.setResizable(false);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("OK");
        JLabel jLabel = new JLabel("From:");
        JLabel jLabel2 = new JLabel("To:");
        Font font = new Font("dialog", 1, 12);
        jLabel.setFont(font);
        jLabel2.setFont(font);
        jButton.setFont(font);
        jPanel.add(jLabel);
        jPanel.add(this.customRangeStart);
        jPanel.add(jLabel2);
        jPanel.add(this.customRangeEnd);
        jPanel2.add(jButton);
        jButton.addActionListener(this);
        this.customRangeDialog.getContentPane().setLayout(new BorderLayout());
        this.customRangeDialog.getContentPane().add("North", jPanel);
        this.customRangeDialog.getContentPane().add("South", jPanel2);
        this.customRangeDialog.pack();
    }

    public int[] getSelectedRange() {
        if (this.useCustomRange) {
            int n;
            int n2;
            String string = "";
            try {
                String string2 = this.customRangeStart.getText().trim();
                String string3 = this.customRangeEnd.getText().trim();
                if (string2.equals(string) && !string3.equals(string)) {
                    n2 = Integer.parseInt(string3, 16);
                    n = n2 - 175;
                } else if (!string2.equals(string) && string3.equals(string)) {
                    n = Integer.parseInt(string2, 16);
                    n2 = n + 175;
                } else {
                    n = Integer.parseInt(this.customRangeStart.getText(), 16);
                    n2 = Integer.parseInt(this.customRangeEnd.getText(), 16);
                }
            }
            catch (Exception exception) {
                this.customRangeStart.setText(Integer.toString(this.customRange[0], 16));
                this.customRangeEnd.setText(Integer.toString(this.customRange[1], 16));
                return this.customRange;
            }
            if (n < 0) {
                n = 0;
            }
            if (n2 > 65535) {
                n2 = 65535;
            }
            if (n > n2) {
                n = n2;
            }
            this.customRange[0] = n;
            this.customRange[1] = n2;
            return this.customRange;
        }
        return UNICODE_RANGES[this.getSelectedIndex()];
    }

    public void setSelectedRange(String string, int n, int n2) {
        this.setSelectedItem(string);
        this.customRange[0] = n;
        this.customRange[1] = n2;
        this.parent.fireRangeChanged();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JComboBox) {
            String string = (String)((JComboBox)object).getSelectedItem();
            if (string.equals("Custom...")) {
                this.useCustomRange = true;
                this.customRangeDialog.setLocationRelativeTo(this.parent);
                this.customRangeDialog.show();
            } else {
                this.useCustomRange = false;
            }
            this.parent.fireRangeChanged();
        } else if (object instanceof JButton) {
            this.customRangeDialog.hide();
        }
    }

    private static int[][] getUnicodeRanges() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(0);
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(0);
        for (int i = 1; i < 0x110000; ++i) {
            Character.UnicodeBlock unicodeBlock2 = Character.UnicodeBlock.of(i);
            if (unicodeBlock == null) {
                if (unicodeBlock2 == null) continue;
                arrayList.add(i);
                unicodeBlock = unicodeBlock2;
                continue;
            }
            if (unicodeBlock2 == null) {
                arrayList.add(i - 1);
                unicodeBlock = null;
                continue;
            }
            if (i == 0x10FFFF) {
                arrayList.add(i);
                continue;
            }
            if (unicodeBlock2.equals(unicodeBlock)) continue;
            arrayList.add(i - 1);
            arrayList.add(i);
            unicodeBlock = unicodeBlock2;
        }
        arrayList.add(0);
        arrayList.add(127);
        int[][] nArray = new int[arrayList.size() / 2][2];
        for (int i = 0; i < arrayList.size() / 2; ++i) {
            nArray[i][0] = (Integer)arrayList.get(2 * i);
            nArray[i][1] = (Integer)arrayList.get(2 * i + 1);
        }
        return nArray;
    }

    private static String[] getUnicodeRangeNames() {
        String[] stringArray = new String[UNICODE_RANGES.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = RangeMenu.titleCase(Character.UnicodeBlock.of(UNICODE_RANGES[i][0]).toString());
        }
        stringArray[stringArray.length - 1] = "Custom...";
        return stringArray;
    }

    private static String titleCase(String string) {
        string = string.replaceAll("_", " ");
        Pattern pattern = Pattern.compile("(^|\\W)([a-z])");
        Matcher matcher = pattern.matcher(string.toLowerCase(Locale.ROOT));
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, matcher.group(1) + matcher.group(2).toUpperCase(Locale.ROOT));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString().replace("Cjk", "CJK").replace("Nko", "NKo");
    }
}

