/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.instrument;

import java.io.IOException;
import java.nio.ByteBuffer;
import jdk.jfr.events.FileForceEvent;
import jdk.jfr.events.FileReadEvent;
import jdk.jfr.events.FileWriteEvent;
import jdk.jfr.internal.instrument.JIInstrumentationMethod;
import jdk.jfr.internal.instrument.JIInstrumentationTarget;

@JIInstrumentationTarget(value="sun.nio.ch.FileChannelImpl")
final class FileChannelImplInstrumentor {
    private String path;

    private FileChannelImplInstrumentor() {
    }

    @JIInstrumentationMethod
    public void force(boolean bl) throws IOException {
        FileForceEvent fileForceEvent = FileForceEvent.EVENT.get();
        if (!fileForceEvent.isEnabled()) {
            this.force(bl);
            return;
        }
        try {
            fileForceEvent.begin();
            this.force(bl);
        }
        finally {
            fileForceEvent.path = this.path;
            fileForceEvent.metaData = bl;
            fileForceEvent.commit();
            fileForceEvent.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public int read(ByteBuffer byteBuffer) throws IOException {
        FileReadEvent fileReadEvent = FileReadEvent.EVENT.get();
        if (!fileReadEvent.isEnabled()) {
            return this.read(byteBuffer);
        }
        int n = 0;
        try {
            fileReadEvent.begin();
            n = this.read(byteBuffer);
        }
        finally {
            if (n < 0) {
                fileReadEvent.endOfFile = true;
            } else {
                fileReadEvent.bytesRead = n;
            }
            fileReadEvent.path = this.path;
            fileReadEvent.commit();
            fileReadEvent.reset();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public int read(ByteBuffer byteBuffer, long l) throws IOException {
        FileReadEvent fileReadEvent = FileReadEvent.EVENT.get();
        if (!fileReadEvent.isEnabled()) {
            return this.read(byteBuffer, l);
        }
        int n = 0;
        try {
            fileReadEvent.begin();
            n = this.read(byteBuffer, l);
        }
        finally {
            if (n < 0) {
                fileReadEvent.endOfFile = true;
            } else {
                fileReadEvent.bytesRead = n;
            }
            fileReadEvent.path = this.path;
            fileReadEvent.commit();
            fileReadEvent.reset();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        FileReadEvent fileReadEvent = FileReadEvent.EVENT.get();
        if (!fileReadEvent.isEnabled()) {
            return this.read(byteBufferArray, n, n2);
        }
        long l = 0L;
        try {
            fileReadEvent.begin();
            l = this.read(byteBufferArray, n, n2);
        }
        finally {
            if (l < 0L) {
                fileReadEvent.endOfFile = true;
            } else {
                fileReadEvent.bytesRead = l;
            }
            fileReadEvent.path = this.path;
            fileReadEvent.commit();
            fileReadEvent.reset();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public int write(ByteBuffer byteBuffer) throws IOException {
        long l;
        FileWriteEvent fileWriteEvent = FileWriteEvent.EVENT.get();
        if (!fileWriteEvent.isEnabled()) {
            return this.write(byteBuffer);
        }
        int n = 0;
        try {
            fileWriteEvent.begin();
            n = this.write(byteBuffer);
            l = n > 0 ? (long)n : 0L;
        }
        catch (Throwable throwable) {
            fileWriteEvent.bytesWritten = n > 0 ? (long)n : 0L;
            fileWriteEvent.path = this.path;
            fileWriteEvent.commit();
            fileWriteEvent.reset();
            throw throwable;
        }
        fileWriteEvent.bytesWritten = l;
        fileWriteEvent.path = this.path;
        fileWriteEvent.commit();
        fileWriteEvent.reset();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public int write(ByteBuffer byteBuffer, long l) throws IOException {
        long l2;
        FileWriteEvent fileWriteEvent = FileWriteEvent.EVENT.get();
        if (!fileWriteEvent.isEnabled()) {
            return this.write(byteBuffer, l);
        }
        int n = 0;
        try {
            fileWriteEvent.begin();
            n = this.write(byteBuffer, l);
            l2 = n > 0 ? (long)n : 0L;
        }
        catch (Throwable throwable) {
            fileWriteEvent.bytesWritten = n > 0 ? (long)n : 0L;
            fileWriteEvent.path = this.path;
            fileWriteEvent.commit();
            fileWriteEvent.reset();
            throw throwable;
        }
        fileWriteEvent.bytesWritten = l2;
        fileWriteEvent.path = this.path;
        fileWriteEvent.commit();
        fileWriteEvent.reset();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        FileWriteEvent fileWriteEvent = FileWriteEvent.EVENT.get();
        if (!fileWriteEvent.isEnabled()) {
            return this.write(byteBufferArray, n, n2);
        }
        long l = 0L;
        try {
            fileWriteEvent.begin();
            l = this.write(byteBufferArray, n, n2);
            fileWriteEvent.bytesWritten = l > 0L ? l : 0L;
        }
        catch (Throwable throwable) {
            fileWriteEvent.bytesWritten = l > 0L ? l : 0L;
            fileWriteEvent.path = this.path;
            fileWriteEvent.commit();
            fileWriteEvent.reset();
            throw throwable;
        }
        fileWriteEvent.path = this.path;
        fileWriteEvent.commit();
        fileWriteEvent.reset();
        return l;
    }
}

