/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.type;

import java.util.Map;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgumentVisitor;
import org.jd.core.v1.model.javasyntax.type.TypeVisitor;
import org.jd.core.v1.model.javasyntax.type.WildcardTypeArgument;

public class GenericType
implements Type {
    protected String name;
    protected int dimension;

    public GenericType(String name) {
        this.name = name;
        this.dimension = 0;
    }

    public GenericType(String name, int dimension) {
        this.name = name;
        this.dimension = dimension;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescriptor() {
        return this.name;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public Type createType(int dimension) {
        assert (dimension >= 0);
        if (this.dimension == dimension) {
            return this;
        }
        return new GenericType(this.name, dimension);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericType that = (GenericType)o;
        if (this.dimension != that.dimension) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = 991890290 + this.name.hashCode();
        result = 31 * result + this.dimension;
        return result;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(TypeArgumentVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isTypeArgumentAssignableFrom(Map<String, BaseType> typeBounds, BaseTypeArgument typeArgument) {
        Class<?> typeArgumentClass = typeArgument.getClass();
        if (typeArgumentClass == GenericType.class) {
            return true;
        }
        if (typeArgument instanceof Type) {
            return false;
        }
        if (typeArgumentClass == WildcardTypeArgument.class) {
            return false;
        }
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GenericType{");
        sb.append(this.name);
        if (this.dimension > 0) {
            sb.append(", dimension=").append(this.dimension);
        }
        return sb.append('}').toString();
    }
}

