/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.codecache.disk;

import jadx.api.ICodeCache;
import jadx.api.ICodeInfo;
import jadx.api.JadxArgs;
import jadx.core.Jadx;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.utils.files.FileUtils;
import jadx.gui.utils.codecache.disk.CodeMetadataAdapter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskCodeCache
implements ICodeCache {
    private static final Logger LOG = LoggerFactory.getLogger(DiskCodeCache.class);
    private static final int DATA_FORMAT_VERSION = 13;
    private static final byte[] JADX_NAMES_MAP_HEADER = "jadxnm".getBytes(StandardCharsets.US_ASCII);
    private final Path srcDir;
    private final Path metaDir;
    private final Path codeVersionFile;
    private final Path namesMapFile;
    private final String codeVersion;
    private final CodeMetadataAdapter codeMetadataAdapter;
    private final ExecutorService writePool;
    private final Map<String, ICodeInfo> writeOps = new ConcurrentHashMap<String, ICodeInfo>();
    private final Map<String, Integer> namesMap = new ConcurrentHashMap<String, Integer>();
    private final Map<String, Integer> allClsIds;

    public DiskCodeCache(RootNode root, Path baseDir) {
        this.srcDir = baseDir.resolve("sources");
        this.metaDir = baseDir.resolve("metadata");
        this.codeVersionFile = baseDir.resolve("code-version");
        this.namesMapFile = baseDir.resolve("names-map");
        JadxArgs args = root.getArgs();
        this.codeVersion = this.buildCodeVersion(args);
        this.writePool = Executors.newFixedThreadPool(args.getThreadsCount());
        this.codeMetadataAdapter = new CodeMetadataAdapter(root);
        this.allClsIds = this.buildClassIdsMap(root.getClasses());
        if (this.checkCodeVersion()) {
            this.loadNamesMap();
        } else {
            this.reset();
        }
    }

    private boolean checkCodeVersion() {
        try {
            if (!Files.exists(this.codeVersionFile, new LinkOption[0])) {
                return false;
            }
            String currentCodeVer = FileUtils.readFile((Path)this.codeVersionFile);
            return currentCodeVer.equals(this.codeVersion);
        }
        catch (Exception e) {
            LOG.warn("Failed to load code version file", (Throwable)e);
            return false;
        }
    }

    private void reset() {
        try {
            long start = System.currentTimeMillis();
            LOG.info("Resetting disk code cache, base dir: {}", (Object)this.srcDir.getParent().toAbsolutePath());
            FileUtils.deleteDirIfExists((Path)this.srcDir);
            FileUtils.deleteDirIfExists((Path)this.metaDir);
            FileUtils.deleteFileIfExists((Path)this.namesMapFile);
            FileUtils.makeDirs((Path)this.srcDir);
            FileUtils.makeDirs((Path)this.metaDir);
            FileUtils.writeFile((Path)this.codeVersionFile, (String)this.codeVersion);
            if (LOG.isDebugEnabled()) {
                LOG.info("Reset done in: {}ms", (Object)(System.currentTimeMillis() - start));
            }
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to reset code cache", (Throwable)e);
        }
        finally {
            this.namesMap.clear();
        }
    }

    public void add(String clsFullName, ICodeInfo codeInfo) {
        this.writeOps.put(clsFullName, codeInfo);
        int clsId = this.getClsId(clsFullName);
        this.namesMap.put(clsFullName, clsId);
        this.writePool.execute(() -> {
            try {
                FileUtils.writeFile((Path)this.getJavaFile(clsId), (String)codeInfo.getCodeStr());
                this.codeMetadataAdapter.write(this.getMetadataFile(clsId), codeInfo.getCodeMetadata());
            }
            catch (Exception e) {
                LOG.error("Failed to write code cache for " + clsFullName, (Throwable)e);
                this.remove(clsFullName);
            }
            finally {
                this.writeOps.remove(clsFullName);
            }
        });
    }

    @Nullable
    public String getCode(String clsFullName) {
        try {
            if (!this.contains(clsFullName)) {
                return null;
            }
            ICodeInfo wrtCodeInfo = this.writeOps.get(clsFullName);
            if (wrtCodeInfo != null) {
                return wrtCodeInfo.getCodeStr();
            }
            int clsId = this.getClsId(clsFullName);
            Path javaFile = this.getJavaFile(clsId);
            if (!Files.exists(javaFile, new LinkOption[0])) {
                return null;
            }
            return FileUtils.readFile((Path)javaFile);
        }
        catch (Exception e) {
            LOG.error("Failed to read class code for {}", (Object)clsFullName, (Object)e);
            return null;
        }
    }

    public ICodeInfo get(String clsFullName) {
        try {
            if (!this.contains(clsFullName)) {
                return ICodeInfo.EMPTY;
            }
            ICodeInfo wrtCodeInfo = this.writeOps.get(clsFullName);
            if (wrtCodeInfo != null) {
                return wrtCodeInfo;
            }
            int clsId = this.getClsId(clsFullName);
            Path javaFile = this.getJavaFile(clsId);
            if (!Files.exists(javaFile, new LinkOption[0])) {
                return ICodeInfo.EMPTY;
            }
            String code = FileUtils.readFile((Path)javaFile);
            return this.codeMetadataAdapter.readAndBuild(this.getMetadataFile(clsId), code);
        }
        catch (Exception e) {
            LOG.error("Failed to read code cache for {}", (Object)clsFullName, (Object)e);
            return ICodeInfo.EMPTY;
        }
    }

    public boolean contains(String clsFullName) {
        return this.namesMap.containsKey(clsFullName);
    }

    public void remove(String clsFullName) {
        try {
            LOG.debug("Removing class info from disk: {}", (Object)clsFullName);
            Integer clsId = this.namesMap.remove(clsFullName);
            if (clsId != null) {
                Files.deleteIfExists(this.getJavaFile(clsId));
                Files.deleteIfExists(this.getMetadataFile(clsId));
            }
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to remove code cache for " + clsFullName, (Throwable)e);
        }
    }

    private String buildCodeVersion(JadxArgs args) {
        return "13:" + Jadx.getVersion() + ":" + args.makeCodeArgsHash() + ":" + this.buildInputsHash(args.getInputFiles());
    }

    /*
     * Exception decompiling
     */
    private String buildInputsHash(List<File> inputs) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int getClsId(String clsFullName) {
        Integer id = this.allClsIds.get(clsFullName);
        if (id == null) {
            throw new JadxRuntimeException("Unknown class name: " + clsFullName);
        }
        return id;
    }

    private void saveNamesMap() {
        LOG.debug("Saving names map for disk cache...");
        try (OutputStream fileOutput = Files.newOutputStream(this.namesMapFile, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
             DataOutputStream out = new DataOutputStream(new BufferedOutputStream(fileOutput));){
            out.write(JADX_NAMES_MAP_HEADER);
            out.writeInt(this.namesMap.size());
            for (Map.Entry<String, Integer> entry : this.namesMap.entrySet()) {
                out.writeUTF(entry.getKey());
                out.writeInt(entry.getValue());
            }
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to save names map file", (Throwable)e);
        }
    }

    private void loadNamesMap() {
        if (!Files.exists(this.namesMapFile, new LinkOption[0])) {
            this.reset();
            return;
        }
        this.namesMap.clear();
        try (InputStream fileInput = Files.newInputStream(this.namesMapFile, new OpenOption[0]);
             DataInputStream in = new DataInputStream(new BufferedInputStream(fileInput));){
            in.skipBytes(JADX_NAMES_MAP_HEADER.length);
            int count = in.readInt();
            for (int i = 0; i < count; ++i) {
                String clsName = in.readUTF();
                int clsId = in.readInt();
                this.namesMap.put(clsName, clsId);
                Integer prevId = this.allClsIds.get(clsName);
                if (prevId != null && prevId == clsId) continue;
                LOG.debug("Unexpected class id, got: {}, expect: {}", (Object)clsId, (Object)prevId);
                LOG.warn("Inconsistent disk cache, resetting...");
                this.reset();
                return;
            }
            LOG.info("Found {} classes in disk cache, dir: {}", (Object)count, (Object)this.metaDir.getParent());
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to load names map file", (Throwable)e);
        }
    }

    private Path getJavaFile(int clsId) {
        return this.srcDir.resolve(this.getPathForClsId(clsId, ".java"));
    }

    private Path getMetadataFile(int clsId) {
        return this.metaDir.resolve(this.getPathForClsId(clsId, ".jadxmd"));
    }

    private Path getPathForClsId(int clsId, String ext) {
        String firstByte = FileUtils.byteToHex((int)clsId);
        return Paths.get(firstByte, FileUtils.intToHex((int)clsId) + ext);
    }

    private Map<String, Integer> buildClassIdsMap(List<ClassNode> classes) {
        int clsCount = classes.size();
        HashMap<String, Integer> map = new HashMap<String, Integer>(clsCount);
        for (int i = 0; i < clsCount; ++i) {
            ClassNode cls = classes.get(i);
            map.put(cls.getRawName(), i);
        }
        return map;
    }

    public void close() throws IOException {
        try {
            this.saveNamesMap();
            this.writePool.shutdown();
            this.writePool.awaitTermination(2L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            LOG.error("Failed to finish file writes", (Throwable)e);
        }
    }
}

