// Generated by gmmproc 2.50.1 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_NAVIGATION_H
#define _GSTREAMERMM_NAVIGATION_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2016 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/video/navigation.h>
#include <glibmm/interface.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GstNavigation = struct _GstNavigation;
using GstNavigationClass = struct _GstNavigationClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gst
{ class Navigation_Class; } // namespace Gst
#endif // DOXYGEN_SHOULD_SKIP_THIS

namespace Gst
{

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var NavigationCommand NAVIGATION_COMMAND_INVALID
 * An invalid command entry.
 * 
 *  @var NavigationCommand NAVIGATION_COMMAND_MENU1
 * Execute navigation menu command 1. For DVD,
 * this enters the DVD root menu, or exits back to the title from the menu.
 * 
 *  @var NavigationCommand NAVIGATION_COMMAND_MENU2
 * Execute navigation menu command 2. For DVD,
 * this jumps to the DVD title menu.
 * 
 *  @var NavigationCommand NAVIGATION_COMMAND_MENU3
 * Execute navigation menu command 3. For DVD,
 * this jumps into the DVD root menu.
 * 
 *  @var NavigationCommand NAVIGATION_COMMAND_MENU4
 * Execute navigation menu command 4. For DVD,
 * this jumps to the Subpicture menu.
 * 
 *  @var NavigationCommand NAVIGATION_COMMAND_MENU5
 * Execute navigation menu command 5. For DVD,
 * the jumps to the audio menu.
 * 
 *  @var NavigationCommand NAVIGATION_COMMAND_MENU6
 * Execute navigation menu command 6. For DVD,
 * this jumps to the angles menu.
 * 
 *  @var NavigationCommand NAVIGATION_COMMAND_MENU7
 * Execute navigation menu command 7. For DVD,
 * this jumps to the chapter menu.
 * 
 *  @var NavigationCommand NAVIGATION_COMMAND_LEFT
 * Select the next button to the left in a menu,
 * if such a button exists.
 * 
 *  @var NavigationCommand NAVIGATION_COMMAND_RIGHT
 * Select the next button to the right in a menu,
 * if such a button exists.
 * 
 *  @var NavigationCommand NAVIGATION_COMMAND_UP
 * Select the button above the current one in a
 * menu, if such a button exists.
 * 
 *  @var NavigationCommand NAVIGATION_COMMAND_DOWN
 * Select the button below the current one in a
 * menu, if such a button exists.
 * 
 *  @var NavigationCommand NAVIGATION_COMMAND_ACTIVATE
 * Activate (click) the currently selected
 * button in a menu, if such a button exists.
 * 
 *  @var NavigationCommand NAVIGATION_COMMAND_PREV_ANGLE
 * Switch to the previous angle in a
 * multiangle feature.
 * 
 *  @var NavigationCommand NAVIGATION_COMMAND_NEXT_ANGLE
 * Switch to the next angle in a multiangle
 * feature.
 * 
 *  @enum NavigationCommand
 * 
 * A set of commands that may be issued to an element providing the
 * Gst::Navigation interface. The available commands can be queried via
 * the gst_navigation_query_new_commands() query.
 * 
 * For convenience in handling DVD navigation, the MENU commands are aliased as:
 * GST_NAVIGATION_COMMAND_DVD_MENU            = @a GST_NAVIGATION_COMMAND_MENU1
 * GST_NAVIGATION_COMMAND_DVD_TITLE_MENU      = @a GST_NAVIGATION_COMMAND_MENU2
 * GST_NAVIGATION_COMMAND_DVD_ROOT_MENU       = @a GST_NAVIGATION_COMMAND_MENU3
 * GST_NAVIGATION_COMMAND_DVD_SUBPICTURE_MENU = @a GST_NAVIGATION_COMMAND_MENU4
 * GST_NAVIGATION_COMMAND_DVD_AUDIO_MENU      = @a GST_NAVIGATION_COMMAND_MENU5
 * GST_NAVIGATION_COMMAND_DVD_ANGLE_MENU      = @a GST_NAVIGATION_COMMAND_MENU6
 * GST_NAVIGATION_COMMAND_DVD_CHAPTER_MENU    = @a GST_NAVIGATION_COMMAND_MENU7
 *
 * @ingroup gstreamermmEnums
 */
enum NavigationCommand
{
  NAVIGATION_COMMAND_INVALID = 0,
  NAVIGATION_COMMAND_MENU1 = 1,
  NAVIGATION_COMMAND_MENU2 = 2,
  NAVIGATION_COMMAND_MENU3 = 3,
  NAVIGATION_COMMAND_MENU4 = 4,
  NAVIGATION_COMMAND_MENU5 = 5,
  NAVIGATION_COMMAND_MENU6 = 6,
  NAVIGATION_COMMAND_MENU7 = 7,
  NAVIGATION_COMMAND_LEFT = 20,
  NAVIGATION_COMMAND_RIGHT = 21,
  NAVIGATION_COMMAND_UP = 22,
  NAVIGATION_COMMAND_DOWN = 23,
  NAVIGATION_COMMAND_ACTIVATE = 24,
  NAVIGATION_COMMAND_PREV_ANGLE = 30,
  NAVIGATION_COMMAND_NEXT_ANGLE = 31
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::NavigationCommand> : public Glib::Value_Enum<Gst::NavigationCommand>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

/** 
 *  @var NavigationEventType NAVIGATION_EVENT_INVALID
 * Returned from
 * gst_navigation_event_get_type() when the passed event is not a navigation event.
 * 
 *  @var NavigationEventType NAVIGATION_EVENT_KEY_PRESS
 * A key press event. Use
 * gst_navigation_event_parse_key_event() to extract the details from the event.
 * 
 *  @var NavigationEventType NAVIGATION_EVENT_KEY_RELEASE
 * A key release event. Use
 * gst_navigation_event_parse_key_event() to extract the details from the event.
 * 
 *  @var NavigationEventType NAVIGATION_EVENT_MOUSE_BUTTON_PRESS
 * A mouse button press event. Use
 * gst_navigation_event_parse_mouse_button_event() to extract the details from the
 * event.
 * 
 *  @var NavigationEventType NAVIGATION_EVENT_MOUSE_BUTTON_RELEASE
 * A mouse button release event. Use
 * gst_navigation_event_parse_mouse_button_event() to extract the details from the
 * event.
 * 
 *  @var NavigationEventType NAVIGATION_EVENT_MOUSE_MOVE
 * A mouse movement event. Use
 * gst_navigation_event_parse_mouse_move_event() to extract the details from the
 * event.
 * 
 *  @var NavigationEventType NAVIGATION_EVENT_COMMAND
 * A navigation command event. Use
 * gst_navigation_event_parse_command() to extract the details from the event.
 * 
 *  @enum NavigationEventType
 * 
 * Enum values for the various events that an element implementing the
 * GstNavigation interface might send up the pipeline.
 *
 * @ingroup gstreamermmEnums
 */
enum NavigationEventType
{
  NAVIGATION_EVENT_INVALID,
  NAVIGATION_EVENT_KEY_PRESS,
  NAVIGATION_EVENT_KEY_RELEASE,
  NAVIGATION_EVENT_MOUSE_BUTTON_PRESS,
  NAVIGATION_EVENT_MOUSE_BUTTON_RELEASE,
  NAVIGATION_EVENT_MOUSE_MOVE,
  NAVIGATION_EVENT_COMMAND
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::NavigationEventType> : public Glib::Value_Enum<Gst::NavigationEventType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

/** 
 *  @var NavigationMessageType NAVIGATION_MESSAGE_INVALID
 * Returned from
 * gst_navigation_message_get_type() when the passed message is not a
 * navigation message.
 * 
 *  @var NavigationMessageType NAVIGATION_MESSAGE_MOUSE_OVER
 * Sent when the mouse moves over or leaves a
 * clickable region of the output, such as a DVD menu button.
 * 
 *  @var NavigationMessageType NAVIGATION_MESSAGE_COMMANDS_CHANGED
 * Sent when the set of available commands
 * changes and should re-queried by interested applications.
 * 
 *  @var NavigationMessageType NAVIGATION_MESSAGE_ANGLES_CHANGED
 * Sent when display angles in a multi-angle
 * feature (such as a multiangle DVD) change - either angles have appeared or
 * disappeared.
 * 
 *  @var NavigationMessageType NAVIGATION_MESSAGE_EVENT
 * Sent when a navigation event was not handled
 * by any element in the pipeline (Since 1.6).
 * 
 *  @enum NavigationMessageType
 * 
 * A set of notifications that may be received on the bus when navigation
 * related status changes.
 *
 * @ingroup gstreamermmEnums
 */
enum NavigationMessageType
{
  NAVIGATION_MESSAGE_INVALID,
  NAVIGATION_MESSAGE_MOUSE_OVER,
  NAVIGATION_MESSAGE_COMMANDS_CHANGED,
  NAVIGATION_MESSAGE_ANGLES_CHANGED,
  NAVIGATION_MESSAGE_EVENT
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::NavigationMessageType> : public Glib::Value_Enum<Gst::NavigationMessageType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

/** 
 *  @var NavigationQueryType NAVIGATION_QUERY_INVALID
 * Invalid query.
 * 
 *  @var NavigationQueryType NAVIGATION_QUERY_COMMANDS
 * Command query.
 * 
 *  @var NavigationQueryType NAVIGATION_QUERY_ANGLES
 * Viewing angle query.
 * 
 *  @enum NavigationQueryType
 * 
 * Tyoes of navigation interface queries.
 *
 * @ingroup gstreamermmEnums
 */
enum NavigationQueryType
{
  NAVIGATION_QUERY_INVALID,
  NAVIGATION_QUERY_COMMANDS,
  NAVIGATION_QUERY_ANGLES
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::NavigationQueryType> : public Glib::Value_Enum<Gst::NavigationQueryType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{


class Structure;

/** An interface for elements that provide navigation functionality.
 * @ingroup GstInterfaces
 *
 * Last reviewed on 2016-06-06 (1.8.0)
 */

class Navigation : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Navigation;
  using CppClassType = Navigation_Class;
  using BaseObjectType = GstNavigation;
  using BaseClassType = GstNavigationInterface;

  // noncopyable
  Navigation(const Navigation&) = delete;
  Navigation& operator=(const Navigation&) = delete;

private:
  friend class Navigation_Class;
  static CppClassType navigation_class_;

#endif /* DOXYGEN_SHOULD_SKIP_THIS */
protected:
  /**
   * You should derive from this class to use it.
   */
  Navigation();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  /** Called by constructors of derived classes. Provide the result of
   * the Class init() function to ensure that it is properly
   * initialized.
   *
   * @param interface_class The Class object for the derived type.
   */
  explicit Navigation(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface.
  explicit Navigation(GstNavigation* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Navigation(Navigation&& src) noexcept;
  Navigation& operator=(Navigation&& src) noexcept;

  ~Navigation() noexcept override;

  static void add_interface(GType gtype_implementer);

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstNavigation*       gobj()       { return reinterpret_cast<GstNavigation*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstNavigation* gobj() const { return reinterpret_cast<GstNavigation*>(gobject_); }

private:


public:
  
  void send_event(Gst::Structure& structure);
  
  /** @param event The type of the key event. Recognised values are "key-press" and
   * "key-release".
   * @param key Character representation of the key. This is typically as produced
   * by XKeysymToString.
   */
  void send_key_event(const Glib::ustring& event, const Glib::ustring& key);
  
  /** Sends a mouse event to the navigation interface. Mouse event coordinates
   * are sent relative to the display space of the related output area. This is
   * usually the size in pixels of the window associated with the element
   * implementing the Gst::Navigation interface.
   * 
   * @param event The type of mouse event, as a text string. Recognised values are
   * "mouse-button-press", "mouse-button-release" and "mouse-move".
   * @param button The button number of the button being pressed or released. Pass 0
   * for mouse-move events.
   * @param x The x coordinate of the mouse event.
   * @param y The y coordinate of the mouse event.
   */
  void send_mouse_event(const Glib::ustring& event, int button, double x, double y);
  
  /** Sends the indicated command to the navigation interface.
   * 
   * @param command The command to issue.
   */
  void send_command(Gst::NavigationCommand command);


  /** Called when an event has been sent to the Gst::Navigation.
   */
  virtual void send_event_vfunc(Gst::Structure&& structure);

protected:

  
public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Navigation
   */
  Glib::RefPtr<Gst::Navigation> wrap(GstNavigation* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_NAVIGATION_H */

