/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.rules;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.internal.rules.RuleAction;
import org.gradle.internal.rules.RuleActionValidationException;
import org.gradle.internal.rules.RuleActionValidator;
import org.gradle.model.internal.type.ModelType;

public class DefaultRuleActionValidator
implements RuleActionValidator {
    private static final String VALID_NO_TYPES = "Rule may not have an input parameter of type: %s.";
    private static final String VALID_MULTIPLE_TYPES = "Rule may not have an input parameter of type: %s. Second parameter must be of type: %s.";
    private final List<Class<?>> validInputType;

    public DefaultRuleActionValidator() {
        this.validInputType = Collections.emptyList();
    }

    public DefaultRuleActionValidator(Class<?> ... validInputTypes) {
        this.validInputType = Arrays.asList(validInputTypes);
    }

    @Override
    public <T> RuleAction<? super T> validate(RuleAction<? super T> ruleAction) {
        this.validateInputTypes(ruleAction);
        return ruleAction;
    }

    private void validateInputTypes(RuleAction<?> ruleAction) {
        for (Class<?> inputType : ruleAction.getInputTypes()) {
            if (this.validInputType.contains(inputType)) continue;
            throw new RuleActionValidationException(this.invalidParameterMessage(inputType));
        }
    }

    private String invalidParameterMessage(Class<?> inputType) {
        if (this.validInputType.isEmpty()) {
            return String.format(VALID_NO_TYPES, inputType.getName());
        }
        return String.format(VALID_MULTIPLE_TYPES, inputType.getName(), this.validTypeNames());
    }

    private String validTypeNames() {
        return this.validInputType.stream().map(ModelType::of).map(ModelType::toString).collect(Collectors.joining(" or "));
    }
}

