/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.ByteOrderMarkFilterInputStream;
import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDate;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListFormatException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLPropertyListParser {
    private static final DocumentBuilderFactory FACTORY = DocumentBuilderFactory.newInstance();

    public static DocumentBuilder getDocBuilder() throws ParserConfigurationException {
        DocumentBuilder builder = FACTORY.newDocumentBuilder();
        builder.setEntityResolver(new PlistDtdResolver());
        return builder;
    }

    public static NSObject parse(File f) throws ParserConfigurationException, IOException, SAXException, PropertyListFormatException, ParseException {
        return XMLPropertyListParser.parse(f.toPath());
    }

    public static NSObject parse(Path path) throws ParserConfigurationException, IOException, SAXException, PropertyListFormatException, ParseException {
        try (InputStream fileInputStream = Files.newInputStream(path, new OpenOption[0]);){
            NSObject nSObject = XMLPropertyListParser.parse(fileInputStream);
            return nSObject;
        }
    }

    public static NSObject parse(byte[] bytes) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            NSObject nSObject = XMLPropertyListParser.parse(inputStream);
            return nSObject;
        }
    }

    public static NSObject parse(InputStream is) throws ParserConfigurationException, IOException, SAXException, PropertyListFormatException, ParseException {
        ByteOrderMarkFilterInputStream filteredInputStream = new ByteOrderMarkFilterInputStream(is, false);
        return XMLPropertyListParser.parse(XMLPropertyListParser.getDocBuilder().parse(filteredInputStream));
    }

    public static NSObject parse(Reader reader) throws ParserConfigurationException, IOException, SAXException, PropertyListFormatException, ParseException {
        return XMLPropertyListParser.parse(XMLPropertyListParser.getDocBuilder().parse(new InputSource(reader)));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NSObject parse(Document doc) throws PropertyListFormatException, IOException, ParseException {
        void var2_5;
        DocumentType docType = doc.getDoctype();
        if (docType == null ? !doc.getDocumentElement().getNodeName().equals("plist") : !docType.getName().equals("plist")) {
            throw new PropertyListFormatException("The given XML document is not a property list.");
        }
        if (doc.getDocumentElement().getNodeName().equals("plist")) {
            List<Node> rootNodes = XMLPropertyListParser.filterElementNodes(doc.getDocumentElement().getChildNodes());
            if (rootNodes.isEmpty()) {
                throw new PropertyListFormatException("The given XML property list has no root element!");
            }
            if (rootNodes.size() != 1) throw new PropertyListFormatException("The given XML property list has more than one root element!");
            Node node = rootNodes.get(0);
            return XMLPropertyListParser.parseObject((Node)var2_5);
        } else {
            Element element = doc.getDocumentElement();
        }
        return XMLPropertyListParser.parseObject((Node)var2_5);
    }

    private static NSObject parseObject(Node n) throws ParseException, IOException {
        String type;
        switch (type = n.getNodeName()) {
            case "dict": {
                NSDictionary dict = new NSDictionary();
                List<Node> children = XMLPropertyListParser.filterElementNodes(n.getChildNodes());
                for (int i = 0; i < children.size(); i += 2) {
                    Node key = children.get(i);
                    Node val = children.get(i + 1);
                    String keyString = XMLPropertyListParser.getNodeTextContents(key);
                    dict.put(keyString, XMLPropertyListParser.parseObject(val));
                }
                return dict;
            }
            case "array": {
                List<Node> children = XMLPropertyListParser.filterElementNodes(n.getChildNodes());
                NSArray array = new NSArray(children.size());
                for (int i = 0; i < children.size(); ++i) {
                    array.setValue(i, XMLPropertyListParser.parseObject(children.get(i)));
                }
                return array;
            }
            case "true": {
                return new NSNumber(true);
            }
            case "false": {
                return new NSNumber(false);
            }
            case "integer": 
            case "real": {
                try {
                    return new NSNumber(XMLPropertyListParser.getNodeTextContents(n));
                }
                catch (IllegalArgumentException ex) {
                    throw new ParseException("The NSNumber object has an invalid format.", -1);
                }
            }
            case "string": {
                return new NSString(XMLPropertyListParser.getNodeTextContents(n));
            }
            case "data": {
                return new NSData(XMLPropertyListParser.getNodeTextContents(n));
            }
            case "date": {
                return new NSDate(XMLPropertyListParser.getNodeTextContents(n));
            }
        }
        return null;
    }

    private static List<Node> filterElementNodes(NodeList list) {
        ArrayList<Node> result = new ArrayList<Node>(list.getLength());
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeType() != 1) continue;
            result.add(list.item(i));
        }
        return result;
    }

    private static String getNodeTextContents(Node n) {
        if (n.getNodeType() == 3 || n.getNodeType() == 4) {
            Text txtNode = (Text)n;
            String content = txtNode.getWholeText();
            if (content == null) {
                return "";
            }
            return content;
        }
        if (n.hasChildNodes()) {
            NodeList children = n.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 3 && child.getNodeType() != 4) continue;
                Text txtNode = (Text)child;
                String content = txtNode.getWholeText();
                if (content == null) {
                    return "";
                }
                return content;
            }
        }
        return "";
    }

    static {
        try {
            FACTORY.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            FACTORY.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            FACTORY.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        try {
            FACTORY.setXIncludeAware(false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        FACTORY.setExpandEntityReferences(false);
        FACTORY.setNamespaceAware(false);
        FACTORY.setIgnoringComments(true);
        FACTORY.setCoalescing(true);
        FACTORY.setValidating(false);
    }

    private static class PlistDtdResolver
    implements EntityResolver {
        private static final String PLIST_PUBLIC_ID_1 = "-//Apple Computer//DTD PLIST 1.0//EN";
        private static final String PLIST_PUBLIC_ID_2 = "-//Apple//DTD PLIST 1.0//EN";

        PlistDtdResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if (PLIST_PUBLIC_ID_1.equals(publicId) || PLIST_PUBLIC_ID_2.equals(publicId)) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
            return null;
        }
    }
}

