/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.cache.ModelSchemaCache;
import org.gradle.model.internal.manage.schema.extract.DefaultModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.EnumStrategy;
import org.gradle.model.internal.manage.schema.extract.InvalidManagedModelElementTypeException;
import org.gradle.model.internal.manage.schema.extract.JavaUtilCollectionStrategy;
import org.gradle.model.internal.manage.schema.extract.JdkValueTypeStrategy;
import org.gradle.model.internal.manage.schema.extract.ManagedImplStructStrategy;
import org.gradle.model.internal.manage.schema.extract.ModelMapStrategy;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspectExtractor;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractor;
import org.gradle.model.internal.manage.schema.extract.ModelSetStrategy;
import org.gradle.model.internal.manage.schema.extract.PrimitiveStrategy;
import org.gradle.model.internal.manage.schema.extract.RuleSourceSchemaExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.SpecializedMapStrategy;
import org.gradle.model.internal.manage.schema.extract.UnmanagedImplStructStrategy;
import org.gradle.model.internal.type.ModelType;

public class DefaultModelSchemaExtractor
implements ModelSchemaExtractor {
    private final List<? extends ModelSchemaExtractionStrategy> strategies;

    public static DefaultModelSchemaExtractor withDefaultStrategies(List<? extends ModelSchemaExtractionStrategy> strategies, ModelSchemaAspectExtractor aspectExtractor) {
        return new DefaultModelSchemaExtractor((List<? extends ModelSchemaExtractionStrategy>)ImmutableList.builder().addAll(strategies).add((Object)new PrimitiveStrategy()).add((Object)new EnumStrategy()).add((Object)new JdkValueTypeStrategy()).add((Object)new ModelSetStrategy()).add((Object)new SpecializedMapStrategy()).add((Object)new ModelMapStrategy()).add((Object)new JavaUtilCollectionStrategy()).add((Object)new ManagedImplStructStrategy(aspectExtractor)).add((Object)new RuleSourceSchemaExtractionStrategy(aspectExtractor)).add((Object)new UnmanagedImplStructStrategy(aspectExtractor)).build());
    }

    public static DefaultModelSchemaExtractor withDefaultStrategies() {
        return DefaultModelSchemaExtractor.withDefaultStrategies(Collections.emptyList(), new ModelSchemaAspectExtractor());
    }

    public DefaultModelSchemaExtractor(List<? extends ModelSchemaExtractionStrategy> strategies) {
        this.strategies = strategies;
    }

    @Override
    public <T> ModelSchema<T> extract(ModelType<T> type, ModelSchemaCache cache) {
        DefaultModelSchemaExtractionContext context = DefaultModelSchemaExtractionContext.root(type);
        ArrayList<DefaultModelSchemaExtractionContext> validations = new ArrayList<DefaultModelSchemaExtractionContext>();
        ArrayDeque unsatisfiedDependencies = new ArrayDeque();
        DefaultModelSchemaExtractionContext extractionContext = context;
        validations.add(extractionContext);
        while (extractionContext != null) {
            this.extractSchema(extractionContext, cache);
            List<DefaultModelSchemaExtractionContext<?>> dependencies = extractionContext.getChildren();
            Iterables.addAll(validations, dependencies);
            this.pushUnsatisfiedDependencies(dependencies, unsatisfiedDependencies, cache);
            extractionContext = (DefaultModelSchemaExtractionContext)unsatisfiedDependencies.poll();
        }
        for (DefaultModelSchemaExtractionContext validationContext : Lists.reverse(validations)) {
            this.validate(validationContext, cache);
        }
        return context.getResult();
    }

    private void pushUnsatisfiedDependencies(Iterable<? extends DefaultModelSchemaExtractionContext<?>> allDependencies, Queue<DefaultModelSchemaExtractionContext<?>> dependencyQueue, final ModelSchemaCache cache) {
        Iterables.addAll(dependencyQueue, (Iterable)Iterables.filter(allDependencies, (Predicate)new Predicate<ModelSchemaExtractionContext<?>>(){

            public boolean apply(ModelSchemaExtractionContext<?> dependency) {
                return cache.get(dependency.getType()) == null;
            }
        }));
    }

    private <T> void validate(DefaultModelSchemaExtractionContext<T> extractionContext, ModelSchemaCache cache) {
        extractionContext.validate(cache.get(extractionContext.getType()));
    }

    private <T> void extractSchema(DefaultModelSchemaExtractionContext<T> extractionContext, ModelSchemaCache cache) {
        ModelType<T> type = extractionContext.getType();
        ModelSchema<T> cached = cache.get(type);
        if (cached != null) {
            extractionContext.found(cached);
            return;
        }
        for (ModelSchemaExtractionStrategy modelSchemaExtractionStrategy : this.strategies) {
            modelSchemaExtractionStrategy.extract(extractionContext);
            if (extractionContext.hasProblems()) {
                throw new InvalidManagedModelElementTypeException(extractionContext);
            }
            if (extractionContext.getResult() == null) continue;
            cache.set(type, extractionContext.getResult());
            return;
        }
        throw new IllegalStateException("No extraction strategy found for type: " + type);
    }
}

